/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.networking.packets;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.containers.VoluminousContainer;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class TankBoolPacket {
    private boolean status;
    private int id;

    public TankBoolPacket() {
    }

    public TankBoolPacket(boolean updatedStatus, int id) {
        this.status = updatedStatus;
        this.id = id;
    }

    public static TankBoolPacket fromBytes(FriendlyByteBuf buffer) {
        TankBoolPacket packet = new TankBoolPacket();
        packet.status = buffer.readBoolean();
        packet.id = buffer.readInt();
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.status);
        buffer.writeInt(this.id);
    }

    public static void handle(TankBoolPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkDirection packetDirection = contextSupplier.get().getDirection();
        switch (packetDirection) {
            case PLAY_TO_CLIENT: {
                AbstractContainerMenu clientContainer = Minecraft.m_91087_().f_91074_.f_36096_;
                contextSupplier.get().enqueueWork(() -> TankBoolPacket.handlePacket(packet, clientContainer, false));
                contextSupplier.get().setPacketHandled(true);
                break;
            }
            default: {
                AbstractContainerMenu serverContainer = contextSupplier.get().getSender().f_36096_;
                contextSupplier.get().enqueueWork(() -> TankBoolPacket.handlePacket(packet, serverContainer, true));
                contextSupplier.get().setPacketHandled(true);
            }
        }
    }

    public static void handlePacket(TankBoolPacket packet, AbstractContainerMenu openContainer, boolean onServer) {
        if (openContainer != null) {
            if (openContainer instanceof VoluminousContainer) {
                BlockEntity tileEntity;
                VoluminousContainer voluminousContainer = (VoluminousContainer)openContainer;
                if (onServer && (tileEntity = voluminousContainer.getTileEntity()) instanceof VEFluidTileEntity) {
                    VEFluidTileEntity veFluidTileEntity = (VEFluidTileEntity)tileEntity;
                    veFluidTileEntity.updateTankPacketFromGui(packet.status, packet.id);
                    veFluidTileEntity.m_6596_();
                }
            } else {
                VoluminousEnergy.LOGGER.warn("TankBoolPacket: Not a valid container.");
            }
        } else {
            VoluminousEnergy.LOGGER.warn("TankBoolPacket The container is null");
        }
    }
}

