/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.networking.packets;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.containers.VoluminousContainer;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class DirectionButtonPacket {
    private int direction;
    private int slotId;

    public DirectionButtonPacket() {
    }

    public DirectionButtonPacket(int updatedDirection, int slot) {
        this.direction = updatedDirection;
        this.slotId = slot;
    }

    public static DirectionButtonPacket fromBytes(FriendlyByteBuf buffer) {
        DirectionButtonPacket packet = new DirectionButtonPacket();
        packet.direction = buffer.readInt();
        packet.slotId = buffer.readInt();
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.direction);
        buffer.writeInt(this.slotId);
    }

    public static void handle(DirectionButtonPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkDirection packetDirection = contextSupplier.get().getDirection();
        switch (packetDirection) {
            case PLAY_TO_CLIENT: {
                AbstractContainerMenu clientContainer = Minecraft.m_91087_().f_91074_.f_36096_;
                contextSupplier.get().enqueueWork(() -> DirectionButtonPacket.handlePacket(packet, clientContainer, false));
                contextSupplier.get().setPacketHandled(true);
                break;
            }
            default: {
                AbstractContainerMenu serverContainer = contextSupplier.get().getSender().f_36096_;
                contextSupplier.get().enqueueWork(() -> DirectionButtonPacket.handlePacket(packet, serverContainer, true));
                contextSupplier.get().setPacketHandled(true);
            }
        }
    }

    public static void handlePacket(DirectionButtonPacket packet, AbstractContainerMenu openContainer, boolean onServer) {
        if (openContainer != null) {
            if (openContainer instanceof VoluminousContainer) {
                VoluminousContainer voluminousContainer = (VoluminousContainer)openContainer;
                if (onServer) {
                    BlockEntity tileEntity = voluminousContainer.getTileEntity();
                    if (tileEntity instanceof VoluminousTileEntity) {
                        VoluminousTileEntity voluminousTileEntity = (VoluminousTileEntity)tileEntity;
                        voluminousTileEntity.updatePacketFromGui(packet.direction, packet.slotId);
                        voluminousTileEntity.m_6596_();
                    }
                } else {
                    voluminousContainer.updateDirectionButton(packet.direction, packet.slotId);
                }
            } else {
                VoluminousEnergy.LOGGER.warn("DirectionButtonPacket: Not a valid container." + openContainer.getClass().getName());
            }
        } else {
            VoluminousEnergy.LOGGER.warn("DirectionButtonPacket: The container is null.");
        }
    }
}

