/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.networking.packets;

import com.veteam.voluminousenergy.blocks.containers.BatteryBoxContainer;
import com.veteam.voluminousenergy.blocks.tiles.BatteryBoxTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BatteryBoxSlotPairPacket {
    private boolean status;
    private int id;

    public BatteryBoxSlotPairPacket() {
    }

    public BatteryBoxSlotPairPacket(boolean status, int id) {
        this.status = status;
        this.id = id;
    }

    public static BatteryBoxSlotPairPacket fromBytes(FriendlyByteBuf buffer) {
        BatteryBoxSlotPairPacket packet = new BatteryBoxSlotPairPacket();
        packet.status = buffer.readBoolean();
        packet.id = buffer.readInt();
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.status);
        buffer.writeInt(this.id);
    }

    public static void handle(BatteryBoxSlotPairPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkDirection packetDirection = contextSupplier.get().getDirection();
        switch (packetDirection) {
            case PLAY_TO_CLIENT: {
                AbstractContainerMenu clientContainer = Minecraft.m_91087_().f_91074_.f_36096_;
                contextSupplier.get().enqueueWork(() -> BatteryBoxSlotPairPacket.handlePacket(packet, clientContainer, false));
                contextSupplier.get().setPacketHandled(true);
                break;
            }
            default: {
                AbstractContainerMenu serverContainer = contextSupplier.get().getSender().f_36096_;
                contextSupplier.get().enqueueWork(() -> BatteryBoxSlotPairPacket.handlePacket(packet, serverContainer, true));
                contextSupplier.get().setPacketHandled(true);
            }
        }
    }

    public static void handlePacket(BatteryBoxSlotPairPacket packet, AbstractContainerMenu openContainer, boolean onServer) {
        if (openContainer != null && openContainer instanceof BatteryBoxContainer) {
            BlockEntity tileEntity;
            BatteryBoxContainer batteryBoxContainer = (BatteryBoxContainer)openContainer;
            if (onServer && (tileEntity = batteryBoxContainer.getTileEntity()) instanceof BatteryBoxTile) {
                BatteryBoxTile batteryBoxTile = (BatteryBoxTile)tileEntity;
                batteryBoxTile.updateSlotPair(packet.status, packet.id);
                batteryBoxTile.m_6596_();
            }
        }
    }
}

