/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.networking.packets;

import com.veteam.voluminousenergy.blocks.containers.BatteryBoxContainer;
import com.veteam.voluminousenergy.blocks.tiles.BatteryBoxTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BatteryBoxSendOutPowerPacket {
    private boolean status;

    public BatteryBoxSendOutPowerPacket() {
    }

    public BatteryBoxSendOutPowerPacket(boolean status) {
        this.status = status;
    }

    public static BatteryBoxSendOutPowerPacket fromBytes(FriendlyByteBuf buffer) {
        BatteryBoxSendOutPowerPacket packet = new BatteryBoxSendOutPowerPacket();
        packet.status = buffer.readBoolean();
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.status);
    }

    public static void handle(BatteryBoxSendOutPowerPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkDirection packetDirection = contextSupplier.get().getDirection();
        switch (packetDirection) {
            case PLAY_TO_CLIENT: {
                AbstractContainerMenu clientContainer = Minecraft.m_91087_().f_91074_.f_36096_;
                contextSupplier.get().enqueueWork(() -> BatteryBoxSendOutPowerPacket.handlePacket(packet, clientContainer, false));
                contextSupplier.get().setPacketHandled(true);
                break;
            }
            default: {
                AbstractContainerMenu serverContainer = contextSupplier.get().getSender().f_36096_;
                contextSupplier.get().enqueueWork(() -> BatteryBoxSendOutPowerPacket.handlePacket(packet, serverContainer, true));
                contextSupplier.get().setPacketHandled(true);
            }
        }
    }

    public static void handlePacket(BatteryBoxSendOutPowerPacket packet, AbstractContainerMenu openContainer, boolean onServer) {
        if (openContainer != null && openContainer instanceof BatteryBoxContainer) {
            BatteryBoxContainer batteryBoxContainer = (BatteryBoxContainer)openContainer;
            if (onServer) {
                BlockEntity tileEntity = batteryBoxContainer.getTileEntity();
                if (tileEntity instanceof BatteryBoxTile) {
                    BatteryBoxTile batteryBoxTile = (BatteryBoxTile)tileEntity;
                    batteryBoxTile.updateSendOutPower(packet.status);
                    batteryBoxTile.m_6596_();
                }
            } else {
                batteryBoxContainer.updateSendOutPowerButton(packet.status);
            }
        }
    }
}

