/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.energy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class VEEnergyStorage
extends EnergyStorage
implements INBTSerializable<Tag> {
    public VEEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void addEnergy(int energy) {
        this.energy += energy;
        if (this.energy > this.getMaxEnergyStored()) {
            this.energy = this.getEnergyStored();
        }
    }

    public void consumeEnergy(int energy) {
        this.energy -= energy;
        if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void serializeNBT(CompoundTag tag) {
        tag.m_128405_("energy", this.getEnergyStored());
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setEnergy(tag.m_128451_("energy"));
    }

    public void setMaxReceive(int amount) {
        this.maxReceive = amount;
    }

    public void deserializeNBT(Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("VEEnergyStorage: Cannot deserialize to an instance that isn't the default implementation!");
        }
        IntTag intNbt = (IntTag)nbt;
        this.setEnergy(intNbt.m_7047_());
    }
}

