/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.energy;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.tools.energy.VEEnergyStorage;
import net.minecraft.world.item.ItemStack;

public class VEEnergyItemStorage
extends VEEnergyStorage {
    private final ItemStack itemStack;

    public VEEnergyItemStorage(ItemStack itemStack, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.itemStack = itemStack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.capacity - energyStored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.writeEnergy(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
        VoluminousEnergy.LOGGER.debug("Extracting Energy from item. energyStored: " + this.getEnergyStored() + " energyExtracted: " + energyExtracted + " new total: " + (this.getEnergyStored() - energyExtracted) + " Max Extract: " + maxExtract);
        if (!simulate) {
            this.writeEnergy(this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.itemStack.m_41784_().m_128451_("energy");
    }

    private void writeEnergy(int amount) {
        this.itemStack.m_41784_().m_128405_("energy", amount);
    }
}

