/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.buttons.tanks;

import com.mojang.blaze3d.systems.RenderSystem;
import com.veteam.voluminousenergy.tools.buttons.VEIOButton;
import com.veteam.voluminousenergy.tools.networking.VENetwork;
import com.veteam.voluminousenergy.tools.networking.packets.TankDirectionPacket;
import com.veteam.voluminousenergy.util.IntToDirection;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.TextUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TankDirectionButton
extends VEIOButton {
    private RelationalTank tank;
    private Direction direction;
    private final ResourceLocation texture = new ResourceLocation("voluminousenergy", "textures/gui/crushergui.png");

    public TankDirectionButton(RelationalTank tank, int x, int y, Button.OnPress onPress) {
        super(x, y, 96, 20, Component.m_130674_((String)""), button -> {
            ((TankDirectionButton)button).cycle();
            onPress.m_93750_(button);
        });
        this.m_252865_(x);
        this.m_253211_(y);
        this.f_93618_ = 96;
        this.f_93619_ = 20;
        this.tank = tank;
        this.direction = tank.getSideDirection();
    }

    private void cycle() {
        switch (this.direction) {
            case UP: {
                this.direction = Direction.DOWN;
                break;
            }
            case DOWN: {
                this.direction = Direction.NORTH;
                break;
            }
            case NORTH: {
                this.direction = Direction.SOUTH;
                break;
            }
            case SOUTH: {
                this.direction = Direction.EAST;
                break;
            }
            case EAST: {
                this.direction = Direction.WEST;
                break;
            }
            default: {
                this.direction = Direction.UP;
            }
        }
    }

    private void setDirection(Direction dir) {
        this.direction = dir;
        this.tank.setSideDirection(dir);
    }

    public void m_87963_(GuiGraphics matrixStack, int p_renderButton1, int p_renderButton2, float p_renderButton3) {
        if (!this.render) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        if (!this.f_93622_) {
            matrixStack.m_280218_(this.texture, this.m_252754_(), this.m_252907_(), 0, 166, this.f_93618_, this.f_93619_);
        } else {
            matrixStack.m_280218_(this.texture, this.m_252754_(), this.m_252907_(), 0, 186, this.f_93618_, this.f_93619_);
        }
        Component textComponent = TextUtil.slotNameWithDirection(this.tank.getTranslationKey(), this.tank.getSideDirection(), this.tank.getId());
        matrixStack.m_280137_(Minecraft.m_91087_().f_91062_, textComponent.getString(), this.m_252754_() + 48, this.m_252907_() + 5, 0xFFFFFF);
    }

    public void m_5691_() {
        if (!this.render) {
            return;
        }
        this.cycle();
        this.tank.setSideDirection(this.direction);
        VENetwork.channel.sendToServer((Object)new TankDirectionPacket(this.getDirection().m_122411_(), this.getId()));
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getId() {
        return this.tank.getId();
    }

    public void setDirectionFromInt(int sideInt) {
        this.setDirection(IntToDirection.IntegerToDirection(sideInt));
    }
}

