/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.veteam.voluminousenergy.tools.Config;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VERender {
    private static final Logger LOGGER = LogManager.getLogger();

    private VERender() {
        throw new IllegalAccessError("Utility class");
    }

    public static void renderGuiTank(Level level, BlockPos tilePos, IFluidHandler fluidHandler, int tank, double x, double y, double zLevel, double width, double height) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        int tankCapacity = fluidHandler.getTankCapacity(tank);
        VERender.renderGuiTank(level, tilePos, stack, tankCapacity, x, y, zLevel, width, height);
    }

    public static void renderGuiTank(Level level, BlockPos tilePos, FluidStack stack, int tankCapacity, double x, double y, double zLevel, double width, double height) {
        int amount;
        try {
            if (stack.getFluid() == null || stack.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            amount = stack.getAmount();
        }
        catch (Exception e) {
            LOGGER.warn("Exception e captured: " + e);
            amount = 0;
        }
        TextureAtlasSprite icon = VERender.getFluidTexture(stack);
        if (icon == null) {
            return;
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)tankCapacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        if (!((Boolean)Config.USE_BIOME_WATER_COLOUR.get()).booleanValue() || stack.getFluid() != Fluids.f_76193_ && stack.getFluid() != Fluids.f_76192_) {
            color = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        } else {
            String colourString = Integer.toHexString(((Biome)level.m_204166_(tilePos).m_203334_()).m_47560_());
            color = Integer.valueOf(colourString, 16);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor() >> 24 & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
        RenderSystem.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.m_118409_();
                float maxU = icon.m_118410_();
                float minV = icon.m_118411_();
                float maxV = icon.m_118412_();
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder tes = tessellator.m_85915_();
                tes.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                tes.m_5483_((double)drawX, (double)(drawY + drawHeight), 0.0).m_7421_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).m_5752_();
                tes.m_5483_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).m_7421_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).m_5752_();
                tes.m_5483_((double)(drawX + drawWidth), (double)drawY, 0.0).m_7421_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).m_5752_();
                tes.m_5483_((double)drawX, (double)drawY, 0.0).m_7421_(minU, minV).m_5752_();
                tessellator.m_85914_();
            }
            i += 16;
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(FluidStack stack) {
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)BlockPos.f_121853_, (FluidState)stack.getFluid().m_76145_());
        return sprites.length > 0 ? sprites[0] : null;
    }
}

