/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="voluminousenergy", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static final String CATEGORY_GENERAL = "General";
    public static final String CATEGORY_FOOD = "Food";
    public static final String CATEGORY_WORLDGEN = "World Generation";
    public static final String CATEGORY_PRIMITIVE_STIRLING_GENERATOR = "Primitive Stirling Generator";
    public static final String CATEGORY_CRUSHER = "Crusher";
    public static final String CATEGORY_ELECTROLYZER = "Electrolyzer";
    public static final String CATEGORY_CENTRIFUGAL_AGITATOR = "Centrifugal Agitator";
    public static final String CATEGORY_COMPRESSOR = "Compressor";
    public static final String CATEGORY_STIRLING_GENERATOR = "Stirling Generator";
    public static final String CATEGORY_COMBUSTION_GENERATOR = "Combustion Generator";
    public static final String CATEGORY_AQUEOULIZER = "Aqueoulizer";
    public static final String CATEGORY_AIR_COMPRESSOR = "Air Compressor";
    public static final String CATEGORY_DISTILLATION_UNIT = "Distillation Unit";
    public static final String CATEGORY_PUMP = "Pump";
    public static final String CATEGORY_GAS_FIRED_FURNACE = "Gas Furnace";
    public static final String CATEGORY_ELECTRIC_FURNACE = "Electric Furnace";
    public static final String CATEGORY_BATTERY_BOX = "Battery Box";
    public static final String CATEGORY_PRIMITIVE_SOLAR_PANEL = "Primitive Solar Panel";
    public static final String CATEGORY_SOLAR_PANEL = "Solar Panel";
    public static final String CATEGORY_CENTRIFUGAL_SEPARATOR = "Centrifugal Separator";
    public static final String CATEGORY_IMPLOSION_COMPRESSOR = "Implosion Compressor";
    public static final String CATEGORY_BLAST_FURNACE = "Blast Furnace";
    public static final String CATEGORY_SAWMILL = "Sawmill";
    public static final String CATEGORY_TANK_BLOCKS = "Tank Blocks";
    public static final String CATEGORY_TOOLING_STATION = "Tooling Station";
    public static final String CATEGORY_FLUID_ELECTROLYZER = "Fluid Electrolyzer";
    public static final String CATEGORY_FLUID_MIXER = "Fluid Mixer";
    public static final String CATEGORY_HYDROPONIC_INCUBATOR = "Hydroponic Incubator";
    public static final String CATEGORY_DIMENSIONAL_LASER = "Dimensional Laser";
    public static final String SUBCATEGORY_FEATURE_GENERATION = "Feature Generation";
    public static final String SUBCATEGORY_CLIMATE_SPAWNS = "Climate Spawns";
    public static final String SUBCATEGORY_ORE_GENERATION = "Ore Generation";
    public static final String SUBCATEGORY_ORE_DEPOSIT_GENERATION = "Ore Deposit Generation";
    public static final String SUBCATEGORY_GALENA = "Galena Ore Settings";
    public static ForgeConfigSpec.BooleanValue WORLD_GEN_LOGGING;
    public static ForgeConfigSpec.BooleanValue PUNCH_HOLES_IN_CLIMATE_SPAWNS;
    public static ForgeConfigSpec.IntValue CLIMATE_SPAWNS_HOLE_PUNCH_MULTIPLIER;
    public static ForgeConfigSpec.IntValue CLIMATE_SPAWNS_HOLE_PUNCH_BOUNDING;
    public static ForgeConfigSpec.IntValue CLIMATE_SPAWNS_HOLE_PUNCH_RNG_MUST_BE_LARGER;
    public static ForgeConfigSpec.IntValue COOKED_RICE_NUTRITION;
    public static ForgeConfigSpec.DoubleValue COOKED_RICE_SATURATION;
    public static ForgeConfigSpec.DoubleValue RICE_TICK_CHANCE;
    public static ForgeConfigSpec.IntValue GALENA_ORE_BLOCK_LIGHT_LEVEL;
    public static ForgeConfigSpec.BooleanValue PREVENT_SURFACE_ORE_DEPOSITS;
    public static ForgeConfigSpec.BooleanValue ALLOW_EXTRACTION_FROM_INPUT_TANKS;
    public static ForgeConfigSpec.DoubleValue ACID_DAMAGE;
    public static ForgeConfigSpec.IntValue ACID_FIRE_DURATION;
    public static ForgeConfigSpec.IntValue SOLARIUM_PROTECTIVE_SHEATH_HITS;
    public static ForgeConfigSpec.DoubleValue SOLARIUM_SHEATH_REGENERATION_CHANCE;
    public static ForgeConfigSpec.IntValue DECREMENT_SPEED_ON_NO_POWER;
    public static ForgeConfigSpec.IntValue PRIMITIVE_STIRLING_GENERATOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue PRIMITIVE_STIRLING_GENERATOR_GENERATE;
    public static ForgeConfigSpec.IntValue PRIMITIVE_STIRLING_GENERATOR_SEND;
    public static ForgeConfigSpec.IntValue CRUSHER_MAX_POWER;
    public static ForgeConfigSpec.IntValue CRUSHER_POWER_USAGE;
    public static ForgeConfigSpec.IntValue CRUSHER_TRANSFER;
    public static ForgeConfigSpec.IntValue ELECTROLYZER_MAX_POWER;
    public static ForgeConfigSpec.IntValue ELECTROLYZER_POWER_USAGE;
    public static ForgeConfigSpec.IntValue ELECTROLYZER_TRANSFER;
    public static ForgeConfigSpec.IntValue CENTRIFUGAL_AGITATOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue CENTRIFUGAL_AGITATOR_POWER_USAGE;
    public static ForgeConfigSpec.IntValue CENTRIFUGAL_AGITATOR_TRANSFER;
    public static ForgeConfigSpec.IntValue COMPRESSOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue COMPRESSOR_POWER_USAGE;
    public static ForgeConfigSpec.IntValue COMPRESSOR_TRANSFER;
    public static ForgeConfigSpec.IntValue STIRLING_GENERATOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue STIRLING_GENERATOR_GENERATE;
    public static ForgeConfigSpec.IntValue STIRLING_GENERATOR_SEND;
    public static ForgeConfigSpec.IntValue COMBUSTION_GENERATOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue COMBUSTION_GENERATOR_SEND;
    public static ForgeConfigSpec.BooleanValue COMBUSTION_GENERATOR_BALANCED_MODE;
    public static ForgeConfigSpec.IntValue COMBUSTION_GENERATOR_FIXED_TICK_TIME;
    public static ForgeConfigSpec.IntValue AQUEOULIZER_MAX_POWER;
    public static ForgeConfigSpec.IntValue AQUEOULIZER_POWER_USAGE;
    public static ForgeConfigSpec.IntValue AQUEOULIZER_TRANSFER;
    public static ForgeConfigSpec.IntValue AIR_COMPRESSOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue AIR_COMPRESSOR_POWER_USAGE;
    public static ForgeConfigSpec.IntValue AIR_COMPRESSOR_TRANSFER;
    public static ForgeConfigSpec.IntValue DISTILLATION_UNIT_MAX_POWER;
    public static ForgeConfigSpec.IntValue DISTILLATION_UNIT_POWER_USAGE;
    public static ForgeConfigSpec.IntValue DISTILLATION_UNIT_TRANSFER;
    public static ForgeConfigSpec.IntValue PUMP_MAX_POWER;
    public static ForgeConfigSpec.IntValue PUMP_POWER_USAGE;
    public static ForgeConfigSpec.IntValue PUMP_TRANSFER;
    public static ForgeConfigSpec.IntValue ELECTRIC_FURNACE_MAX_POWER;
    public static ForgeConfigSpec.IntValue ELECTRIC_FURNACE_POWER_USAGE;
    public static ForgeConfigSpec.IntValue ELECTRIC_FURNACE_TRANSFER;
    public static ForgeConfigSpec.IntValue BATTERY_BOX_MAX_POWER;
    public static ForgeConfigSpec.IntValue BATTERY_BOX_TRANSFER;
    public static ForgeConfigSpec.IntValue PRIMITIVE_SOLAR_PANEL_MAX_POWER;
    public static ForgeConfigSpec.IntValue PRIMITIVE_SOLAR_PANEL_GENERATE;
    public static ForgeConfigSpec.IntValue PRIMITIVE_SOLAR_PANEL_SEND;
    public static ForgeConfigSpec.IntValue SOLAR_PANEL_MAX_POWER;
    public static ForgeConfigSpec.IntValue SOLAR_PANEL_GENERATE;
    public static ForgeConfigSpec.IntValue SOLAR_PANEL_SEND;
    public static ForgeConfigSpec.IntValue CENTRIFUGAL_SEPARATOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue CENTRIFUGAL_SEPARATOR_POWER_USAGE;
    public static ForgeConfigSpec.IntValue CENTRIFUGAL_SEPARATOR_TRANSFER;
    public static ForgeConfigSpec.IntValue IMPLOSION_COMPRESSOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue IMPLOSION_COMPRESSOR_POWER_USAGE;
    public static ForgeConfigSpec.IntValue IMPLOSION_COMPRESSOR_TRANSFER;
    public static ForgeConfigSpec.IntValue BLAST_FURNACE_MAX_POWER;
    public static ForgeConfigSpec.IntValue BLAST_FURNACE_POWER_USAGE;
    public static ForgeConfigSpec.IntValue BLAST_FURNACE_TRANSFER;
    public static ForgeConfigSpec.IntValue BLAST_FURNACE_HEAT_SOURCE_CONSUMPTION;
    public static ForgeConfigSpec.IntValue SAWMILL_MAX_POWER;
    public static ForgeConfigSpec.IntValue SAWMILL_POWER_USAGE;
    public static ForgeConfigSpec.IntValue SAWMILL_TRANSFER;
    public static ForgeConfigSpec.BooleanValue SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED;
    public static ForgeConfigSpec.ConfigValue<String> SAWMILL_FLUID_LOCATION;
    public static ForgeConfigSpec.ConfigValue<String> SAWMILL_SECOND_OUTPUT_RESOURCE_LOCATION;
    public static ForgeConfigSpec.IntValue SAWMILL_FLUID_AMOUNT;
    public static ForgeConfigSpec.IntValue SAWMILL_SECOND_OUTPUT_COUNT;
    public static ForgeConfigSpec.IntValue SAWMILL_PROCESSING_TIME;
    public static ForgeConfigSpec.IntValue SAWMILL_PRIMARY_OUTPUT_COUNT;
    public static ForgeConfigSpec.IntValue SAWMILL_LOG_CONSUMPTION_RATE;
    public static ForgeConfigSpec.IntValue TOOLING_STATION_MAX_POWER;
    public static ForgeConfigSpec.IntValue TOOLING_STATION_TRANSFER;
    public static ForgeConfigSpec.IntValue FLUID_ELECTROLYZER_MAX_POWER;
    public static ForgeConfigSpec.IntValue FLUID_ELECTROLYZER_POWER_USAGE;
    public static ForgeConfigSpec.IntValue FLUID_ELECTROLYZER_TRANSFER;
    public static ForgeConfigSpec.IntValue FLUID_MIXER_MAX_POWER;
    public static ForgeConfigSpec.IntValue FLUID_MIXER_POWER_USAGE;
    public static ForgeConfigSpec.IntValue FLUID_MIXER_TRANSFER;
    public static ForgeConfigSpec.IntValue HYDROPONIC_INCUBATOR_MAX_POWER;
    public static ForgeConfigSpec.IntValue HYDROPONIC_INCUBATOR_POWER_USAGE;
    public static ForgeConfigSpec.IntValue HYDROPONIC_INCUBATOR_TRANSFER;
    public static ForgeConfigSpec.IntValue DIMENSIONAL_LASER_MAX_POWER;
    public static ForgeConfigSpec.IntValue DIMENSIONAL_LASER_POWER_USAGE;
    public static ForgeConfigSpec.IntValue DIMENSIONAL_LASER_TRANSFER;
    public static ForgeConfigSpec.IntValue DIMENSIONAL_LASER_PROCESS_TIME;
    public static ForgeConfigSpec.IntValue DIMENSIONAL_LASER_FLUID_RATE;
    public static ForgeConfigSpec.IntValue SOLARIUM_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue EIGHZO_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue NIGHALITE_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue NETHERITE_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue TITANIUM_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue ALUMINUM_TANK_CAPACITY;
    public static ForgeConfigSpec.BooleanValue USE_BIOME_WATER_COLOUR;
    public static ForgeConfigSpec.BooleanValue SHORTEN_ITEM_TOOLTIP_VALUES;
    public static ForgeConfigSpec.BooleanValue SHORTEN_POWER_BAR_VALUES;
    public static ForgeConfigSpec.BooleanValue SHORTEN_TANK_GUI_VALUES;
    public static ForgeConfigSpec.BooleanValue PLAY_MACHINE_SOUNDS;

    private static void buildCommonConfig() {
        COMMON_BUILDER.comment("General Settings").push(CATEGORY_GENERAL);
        Config.setupGeneralSettings();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Food Settings").push(CATEGORY_FOOD);
        Config.setupFoodSettings();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("World Generation Settings").push(CATEGORY_WORLDGEN);
        Config.setupWorldGen();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Primitive Stirling Generator Settings").push(CATEGORY_PRIMITIVE_STIRLING_GENERATOR);
        Config.setupPrimitiveStirlingGeneratorConfig();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Crusher Settings").push(CATEGORY_CRUSHER);
        Config.setupCrusher();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Electrolyzer Settings").push(CATEGORY_ELECTROLYZER);
        Config.setupElectrolyzer();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Centrifugal Agitator Settings").push(CATEGORY_CENTRIFUGAL_AGITATOR);
        Config.setupCentrifugalAgitator();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Compressor Settings").push(CATEGORY_COMPRESSOR);
        Config.setupCompressor();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Stirling Generator Settings").push(CATEGORY_STIRLING_GENERATOR);
        Config.setupStirlingGenerator();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Combustion Generator Settings").push(CATEGORY_COMBUSTION_GENERATOR);
        Config.setupCombustionGenerator();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Aqueoulizer Settings").push(CATEGORY_AQUEOULIZER);
        Config.setupAqueoulizer();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Air Compressor Settings").push(CATEGORY_AIR_COMPRESSOR);
        Config.setupAirCompressor();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Distillation Unit Settings").push(CATEGORY_DISTILLATION_UNIT);
        Config.setupDistillationUnit();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Pump Settings").push(CATEGORY_PUMP);
        Config.setupPump();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Gas Furnace Settings").push(CATEGORY_GAS_FIRED_FURNACE);
        Config.setupGasFiredFurnace();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Electric Furnace Settings").push(CATEGORY_ELECTRIC_FURNACE);
        Config.setupElectricFurnace();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Battery Box Settings").push(CATEGORY_BATTERY_BOX);
        Config.setupBatteryBox();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_PRIMITIVE_SOLAR_PANEL).push(CATEGORY_PRIMITIVE_SOLAR_PANEL);
        Config.setupPrimitiveSolarPanel();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_SOLAR_PANEL).push(CATEGORY_SOLAR_PANEL);
        Config.setupSolarPanel();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_CENTRIFUGAL_SEPARATOR).push(CATEGORY_CENTRIFUGAL_SEPARATOR);
        Config.setupCentrifugalSeparator();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_IMPLOSION_COMPRESSOR).push(CATEGORY_IMPLOSION_COMPRESSOR);
        Config.setupImplosionCompressor();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_BLAST_FURNACE).push(CATEGORY_BLAST_FURNACE);
        Config.setupBlastFurnace();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_SAWMILL).push(CATEGORY_SAWMILL);
        Config.setupSawmill();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_TANK_BLOCKS).push(CATEGORY_TANK_BLOCKS);
        Config.setupTankBlocks();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_TOOLING_STATION).push(CATEGORY_TOOLING_STATION);
        Config.setupToolingStation();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_FLUID_ELECTROLYZER).push(CATEGORY_FLUID_ELECTROLYZER);
        Config.setupFluidElectrolyzer();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_FLUID_MIXER).push(CATEGORY_FLUID_MIXER);
        Config.setupFluidMixer();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_HYDROPONIC_INCUBATOR).push(CATEGORY_HYDROPONIC_INCUBATOR);
        Config.setupHydroponicIncubatorMixer();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(CATEGORY_DIMENSIONAL_LASER).push(CATEGORY_DIMENSIONAL_LASER);
        Config.setupDimensionalLaser();
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    private static void setupGeneralSettings() {
        ALLOW_EXTRACTION_FROM_INPUT_TANKS = COMMON_BUILDER.comment("Allow pipes to extract fluids from fluid input tanks. Disabling this means that only fluid outputs can be extracted from Tile Entites").define("Allow Extraction from Input Tanks", false);
        ACID_DAMAGE = COMMON_BUILDER.comment("Damage taken from standing in an acid.").defineInRange("Acid Damage", 3.0, 0.0, 3.4028234663852886E38);
        ACID_FIRE_DURATION = COMMON_BUILDER.comment("Duration of fire on an entity for stepping into an acid.").defineInRange("Acid Fire Duration", 4, 0, Integer.MAX_VALUE);
        SOLARIUM_PROTECTIVE_SHEATH_HITS = COMMON_BUILDER.comment("How many uses a Solarium tool can have before the protective sheath is depleted").defineInRange("Solarium Protective Sheath", 2560, 0, Integer.MAX_VALUE);
        SOLARIUM_SHEATH_REGENERATION_CHANCE = COMMON_BUILDER.comment("The percent chance (as a decimal) of a Solarium sheath regenerating on a tick when exposed to skylight").defineInRange("Solarium Sheath Regeneration Chance", 0.0175, 0.0, 1.0);
        DECREMENT_SPEED_ON_NO_POWER = COMMON_BUILDER.comment("Speed of which progress should be undone at a machine when the machine loses power/FE").defineInRange("Decrement Speed On No Power", 5, 1, 20);
        PLAY_MACHINE_SOUNDS = CLIENT_BUILDER.comment("When running a machine, should the machine's sound be played?").define("Play Machine Sounds", false);
    }

    private static void setupFoodSettings() {
        COOKED_RICE_NUTRITION = COMMON_BUILDER.comment("Nutritional value of Cooked Rice.").defineInRange("Cooked Rice Nutrition", 5, 1, Integer.MAX_VALUE);
        COOKED_RICE_SATURATION = COMMON_BUILDER.comment("Saturation of Cooked Rice.").defineInRange("Cooked Rice Saturation", (double)0.3f, 1.1754943508222875E-38, 3.4028234663852886E38);
        RICE_TICK_CHANCE = COMMON_BUILDER.comment("Chance of Rice crop going to next life stage.").defineInRange("Rice Tick Chance", 0.5, 1.1754943508222875E-38, 1.0);
    }

    private static void setupWorldGen() {
        COMMON_BUILDER.comment(SUBCATEGORY_FEATURE_GENERATION).push(SUBCATEGORY_FEATURE_GENERATION);
        WORLD_GEN_LOGGING = COMMON_BUILDER.comment("Enable/Disable Logging of Word Generation information for Voluminous Energy features and Ores").define("Enable Logging", false);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(SUBCATEGORY_CLIMATE_SPAWNS).push(SUBCATEGORY_CLIMATE_SPAWNS);
        PUNCH_HOLES_IN_CLIMATE_SPAWNS = COMMON_BUILDER.comment("To prevent continuous valid chunks, 'punch holes' by removing spawns from valid chunks (Ex: Reduce non-water or lava appearances for the Dimensional Laser)").define("Punch Holes in Climate Spawns", true);
        CLIMATE_SPAWNS_HOLE_PUNCH_MULTIPLIER = COMMON_BUILDER.comment("Multiply cumulative climate value by this multiplier ").defineInRange("Climate Spawns Hole Punch Multiplier", 10000, 1, Integer.MAX_VALUE);
        CLIMATE_SPAWNS_HOLE_PUNCH_BOUNDING = COMMON_BUILDER.comment("Value to be used for binding the RNG ").defineInRange("Climate Spawns Hole Punch Bounding", 100, 10, 10000);
        CLIMATE_SPAWNS_HOLE_PUNCH_RNG_MUST_BE_LARGER = COMMON_BUILDER.comment("If generated number is smaller than this value, the chunk will be 'hole punched'.").defineInRange("Climate Spawns Hole Punch Number Must Be Larger Than", 47, 1, 10000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment(SUBCATEGORY_ORE_GENERATION).push(SUBCATEGORY_ORE_GENERATION);
        COMMON_BUILDER.comment(SUBCATEGORY_GALENA).push(SUBCATEGORY_GALENA);
        GALENA_ORE_BLOCK_LIGHT_LEVEL = COMMON_BUILDER.defineInRange("Galena Light Glow Level", 4, 0, 16);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Ore Deposits: Large cluster of ore and raw block, more compact than an ore vein, but bigger than an ore blob.").push(SUBCATEGORY_ORE_DEPOSIT_GENERATION);
        PREVENT_SURFACE_ORE_DEPOSITS = COMMON_BUILDER.comment("Prevent the generation of ore deposits with exposure to the world's surface").define("Disallow surface ore deposits", false);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
    }

    private static void setupPrimitiveStirlingGeneratorConfig() {
        PRIMITIVE_STIRLING_GENERATOR_MAX_POWER = COMMON_BUILDER.comment("Maximum power for the Primitive Stirling Generator to store").defineInRange("Maximum Power", 100000, 0, Integer.MAX_VALUE);
        PRIMITIVE_STIRLING_GENERATOR_GENERATE = COMMON_BUILDER.comment("Power generation per tick").defineInRange("Generation (Per Tick)", 40, 0, Integer.MAX_VALUE);
        PRIMITIVE_STIRLING_GENERATOR_SEND = COMMON_BUILDER.comment("Power generation to send per tick").defineInRange("Output Rate", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupCrusher() {
        CRUSHER_MAX_POWER = COMMON_BUILDER.comment("Maximum power for the Crusher to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        CRUSHER_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Crusher").defineInRange("Power Consumption", 40, 0, Integer.MAX_VALUE);
        CRUSHER_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Crusher").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupElectrolyzer() {
        ELECTROLYZER_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Electrolyzer to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        ELECTROLYZER_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Electrolyzer").defineInRange("Power Consumption", 40, 0, Integer.MAX_VALUE);
        ELECTROLYZER_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Electrolyzer").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupCentrifugalAgitator() {
        CENTRIFUGAL_AGITATOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Centrifugal Agitator to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        CENTRIFUGAL_AGITATOR_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Centrifugal Agitator").defineInRange("Power Consumption", 40, 0, Integer.MAX_VALUE);
        CENTRIFUGAL_AGITATOR_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Centrifugal Agitator").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupCompressor() {
        COMPRESSOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Compressor to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        COMPRESSOR_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Compressor").defineInRange("Power Consumption", 40, 0, Integer.MAX_VALUE);
        COMPRESSOR_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Compressor").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupStirlingGenerator() {
        STIRLING_GENERATOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Stirling Generator to store").defineInRange("Maximum Power", 5120000, 0, Integer.MAX_VALUE);
        STIRLING_GENERATOR_GENERATE = COMMON_BUILDER.comment("Fallback value for power generation for the Stirling Generator").defineInRange("Fallback Generation Rate", 128, 0, Integer.MAX_VALUE);
        STIRLING_GENERATOR_SEND = COMMON_BUILDER.comment("Maximum power to send out per tick for the Stirling Generator").defineInRange("Maximum Transfer", 128000, 0, Integer.MAX_VALUE);
    }

    private static void setupCombustionGenerator() {
        COMBUSTION_GENERATOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Combustion Generator to store").defineInRange("Maximum Power", 5120000, 0, Integer.MAX_VALUE);
        COMBUSTION_GENERATOR_SEND = COMMON_BUILDER.comment("Maximum power to send out per tick for the Combustion Generator").defineInRange("Maximum Transfer", 512000, 0, Integer.MAX_VALUE);
        COMBUSTION_GENERATOR_BALANCED_MODE = COMMON_BUILDER.comment("If true, the Combustion Generator will use the process time from the oxidizer's recipe rather than the static process time").define("Balanced Mode", false);
        COMBUSTION_GENERATOR_FIXED_TICK_TIME = COMMON_BUILDER.comment("The fixed process time for the Combustion Generator is Balanced Mode is not used.").defineInRange("Fixed Process Time", 1600, 0, Integer.MAX_VALUE);
    }

    private static void setupAqueoulizer() {
        AQUEOULIZER_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Aqueoulizer to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        AQUEOULIZER_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Aqueoulizer").defineInRange("Power Consumption", 40, 0, Integer.MAX_VALUE);
        AQUEOULIZER_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Aqueoulizer").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupAirCompressor() {
        AIR_COMPRESSOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Air Compressor to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        AIR_COMPRESSOR_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Air Compressor").defineInRange("Power Consumption", 24, 0, Integer.MAX_VALUE);
        AIR_COMPRESSOR_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Air Compressor").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupDistillationUnit() {
        DISTILLATION_UNIT_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Distillation Unit to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        DISTILLATION_UNIT_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Distillation Unit").defineInRange("Power Consumption", 64, 0, Integer.MAX_VALUE);
        DISTILLATION_UNIT_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Distillation Unit").defineInRange("Maximum Transfer", 2500, 0, Integer.MAX_VALUE);
    }

    private static void setupPump() {
        PUMP_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Pump to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        PUMP_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Pump").defineInRange("Power Consumption", 16, 0, Integer.MAX_VALUE);
        PUMP_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Pump").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    @Deprecated
    private static void setupGasFiredFurnace() {
    }

    private static void setupElectricFurnace() {
        ELECTRIC_FURNACE_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Electric Furnace to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        ELECTRIC_FURNACE_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Electric Furnace").defineInRange("Power Consumption", 64, 0, Integer.MAX_VALUE);
        ELECTRIC_FURNACE_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Electric Furnace").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupBatteryBox() {
        BATTERY_BOX_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Battery Box to store").defineInRange("Maximum Power", 50000, 0, Integer.MAX_VALUE);
        BATTERY_BOX_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Battery Box").defineInRange("Maximum Transfer", 5000, 0, Integer.MAX_VALUE);
    }

    public static void setupPrimitiveSolarPanel() {
        PRIMITIVE_SOLAR_PANEL_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Primitive Solar Panel to store").defineInRange("Maximum Power", 100000, 0, Integer.MAX_VALUE);
        PRIMITIVE_SOLAR_PANEL_GENERATE = COMMON_BUILDER.comment("Value for power generation for the Primitive Solar Panel").defineInRange("Generation Rate", 64, 0, Integer.MAX_VALUE);
        PRIMITIVE_SOLAR_PANEL_SEND = COMMON_BUILDER.comment("Maximum power to send out per tick for the Primitive Solar Panel").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    public static void setupSolarPanel() {
        SOLAR_PANEL_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Solar Panel to store").defineInRange("Maximum Power", 250000, 0, Integer.MAX_VALUE);
        SOLAR_PANEL_GENERATE = COMMON_BUILDER.comment("Value for power generation for the Solar Panel").defineInRange("Generation Rate", 128, 0, Integer.MAX_VALUE);
        SOLAR_PANEL_SEND = COMMON_BUILDER.comment("Maximum power to send out per tick for the Solar Panel").defineInRange("Maximum Transfer", 5000, 0, Integer.MAX_VALUE);
    }

    private static void setupCentrifugalSeparator() {
        CENTRIFUGAL_SEPARATOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Centrifugal Separator to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        CENTRIFUGAL_SEPARATOR_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Centrifugal Separator").defineInRange("Power Consumption", 40, 0, Integer.MAX_VALUE);
        CENTRIFUGAL_SEPARATOR_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Centrifugal Separator").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupImplosionCompressor() {
        IMPLOSION_COMPRESSOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Implosion Compressor to store").defineInRange("Maximum Power", 128000, 0, Integer.MAX_VALUE);
        IMPLOSION_COMPRESSOR_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Implosion Compressor").defineInRange("Power Consumption", 128, 0, Integer.MAX_VALUE);
        IMPLOSION_COMPRESSOR_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Implosion Compressor").defineInRange("Maximum Transfer", 2500, 0, Integer.MAX_VALUE);
    }

    private static void setupBlastFurnace() {
        BLAST_FURNACE_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Blast Furnace to store").defineInRange("Maximum Power", 512000, 0, Integer.MAX_VALUE);
        BLAST_FURNACE_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Blast Furnace").defineInRange("Power Consumption", 256, 0, Integer.MAX_VALUE);
        BLAST_FURNACE_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Blast Furnace").defineInRange("Maximum Transfer", 10000, 0, Integer.MAX_VALUE);
        BLAST_FURNACE_HEAT_SOURCE_CONSUMPTION = COMMON_BUILDER.comment("Amount of fluid that is consumed per blasting operation for heat").defineInRange("Heat Source Consumption", 50, 0, 4000);
    }

    private static void setupSawmill() {
        SAWMILL_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Sawmill to store").defineInRange("Maximum Power", 512000, 0, Integer.MAX_VALUE);
        SAWMILL_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Sawmill").defineInRange("Power Consumption", 64, 0, Integer.MAX_VALUE);
        SAWMILL_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Sawmill").defineInRange("Maximum Transfer", 10000, 0, Integer.MAX_VALUE);
        SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED = COMMON_BUILDER.comment("true/false, Allow the use of logs that don't have a proper Sawmill recipe").define("Allow logs without recipe", true);
        SAWMILL_FLUID_LOCATION = COMMON_BUILDER.comment("Resource Location of the fluid that will be generated when processing a log without a recipe").define("Fluid location", (Object)"voluminousenergy:tree_sap");
        SAWMILL_FLUID_AMOUNT = COMMON_BUILDER.comment("Amount of fluid that will be generated when processing a log without a recipe").defineInRange("Fluid Amount", 250, 0, 4000);
        SAWMILL_SECOND_OUTPUT_RESOURCE_LOCATION = COMMON_BUILDER.comment("Resource Location of the second output item when processing a log without a recipe").define("Second output item resource location", (Object)"voluminousenergy:saw_dust");
        SAWMILL_SECOND_OUTPUT_COUNT = COMMON_BUILDER.comment("Item count of the second output item when processing a log without a recipe").defineInRange("Second output count", 1, 0, 64);
        SAWMILL_PROCESSING_TIME = COMMON_BUILDER.comment("Processing time when processing a log without a recipe").defineInRange("Processing time", 200, 0, Integer.MAX_VALUE);
        SAWMILL_PRIMARY_OUTPUT_COUNT = COMMON_BUILDER.comment("Amount of the primary item (typically a plank) that will be generated when finished processing a log without a recipe").defineInRange("Primary output count", 6, 1, 64);
        SAWMILL_LOG_CONSUMPTION_RATE = COMMON_BUILDER.comment("Amount of the input item (typically a log) that will be consumed when finished processing a log without a recipe").defineInRange("Number of logs to consume", 1, 1, 64);
    }

    private static void setupTankBlocks() {
        SOLARIUM_TANK_CAPACITY = COMMON_BUILDER.comment("Maximum tank capacity in Buckets").defineInRange("Solarium Tank Capacity", 2147483, 0, 2147483);
        EIGHZO_TANK_CAPACITY = COMMON_BUILDER.comment("Maximum tank capacity in Buckets").defineInRange("Eighzo Tank Capacity", 536870, 0, 2147483);
        NIGHALITE_TANK_CAPACITY = COMMON_BUILDER.comment("Maximum tank capacity in Buckets").defineInRange("Nighalite Tank Capacity", 67108, 0, 2147483);
        NETHERITE_TANK_CAPACITY = COMMON_BUILDER.comment("Maximum tank capacity in Buckets").defineInRange("Netherite Tank Capacity", 8388, 0, 2147483);
        TITANIUM_TANK_CAPACITY = COMMON_BUILDER.comment("Maximum tank capacity in Buckets").defineInRange("Titanium Tank Capacity", 524, 0, 2147483);
        ALUMINUM_TANK_CAPACITY = COMMON_BUILDER.comment("Maximum tank capacity in Buckets").defineInRange("Aluminum Tank Capacity", 64, 0, 2147483);
    }

    private static void setupToolingStation() {
        TOOLING_STATION_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Tooling Station to store").defineInRange("Maximum Power", 5000, 0, Integer.MAX_VALUE);
        TOOLING_STATION_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Tooling Station").defineInRange("Maximum Transfer", 1000, 0, Integer.MAX_VALUE);
    }

    private static void setupFluidElectrolyzer() {
        FLUID_ELECTROLYZER_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Fluid Electrolyzer to store").defineInRange("Maximum Power", 128000, 0, Integer.MAX_VALUE);
        FLUID_ELECTROLYZER_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Fluid Electrolyzer").defineInRange("Power Consumption", 128, 0, Integer.MAX_VALUE);
        FLUID_ELECTROLYZER_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Fluid Electrolyzer").defineInRange("Maximum Transfer", 25000, 0, Integer.MAX_VALUE);
    }

    private static void setupFluidMixer() {
        FLUID_MIXER_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Fluid Mixer to store").defineInRange("Maximum Power", 128000, 0, Integer.MAX_VALUE);
        FLUID_MIXER_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Fluid Mixer").defineInRange("Power Consumption", 96, 0, Integer.MAX_VALUE);
        FLUID_MIXER_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Fluid Mixer").defineInRange("Maximum Transfer", 25000, 0, Integer.MAX_VALUE);
    }

    private static void setupHydroponicIncubatorMixer() {
        HYDROPONIC_INCUBATOR_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Hydroponic Incubator to store").defineInRange("Maximum Power", 128000, 0, Integer.MAX_VALUE);
        HYDROPONIC_INCUBATOR_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Hydroponic Incubator").defineInRange("Power Consumption", 96, 0, Integer.MAX_VALUE);
        HYDROPONIC_INCUBATOR_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Hydroponic Incubator").defineInRange("Maximum Transfer", 25000, 0, Integer.MAX_VALUE);
    }

    private static void setupDimensionalLaser() {
        DIMENSIONAL_LASER_MAX_POWER = COMMON_BUILDER.comment("Maximum Power for the Dimensional Laser to store").defineInRange("Maximum Power", 0x1FFFFFFF, 0, Integer.MAX_VALUE);
        DIMENSIONAL_LASER_POWER_USAGE = COMMON_BUILDER.comment("Power consumption per tick for the Dimensional Laser").defineInRange("Power Consumption", 1024, 0, Integer.MAX_VALUE);
        DIMENSIONAL_LASER_TRANSFER = COMMON_BUILDER.comment("Power I/O per tick for the Dimensional Laser").defineInRange("Maximum Transfer", 0x7FFFFFF, 0, Integer.MAX_VALUE);
        DIMENSIONAL_LASER_FLUID_RATE = COMMON_BUILDER.comment("For each time an extraction is complete, how much fluid should be extracted from the chunk and placed in the output tank").defineInRange("Fluid Extraction Rate", 250, 0, 4000);
        DIMENSIONAL_LASER_PROCESS_TIME = COMMON_BUILDER.comment("How long should it take (it ticks) to extract a fluid from a chunk for a single extraction").defineInRange("Process Time", 20, 0, Integer.MAX_VALUE);
    }

    private static void buildClientConfig() {
        CLIENT_BUILDER.comment("General Client Settings").push(CATEGORY_GENERAL);
        USE_BIOME_WATER_COLOUR = CLIENT_BUILDER.comment("When rendering water in tanks, use the water's biome appropriate colour, instead of the generic universal water colour.").define("Use Biome Water Colour", true);
        SHORTEN_ITEM_TOOLTIP_VALUES = CLIENT_BUILDER.comment("When displaying larger numbers on a tooltip of an item you hover over, change the units to keep the numbers small (eg 1 B instead of 1000 mB).").define("Shorten Item Tooltip Values", true);
        SHORTEN_POWER_BAR_VALUES = CLIENT_BUILDER.comment("When displaying larger numbers on a tooltip for the machines power bar, change the units to keep the numbers small (eg 1 kFE instead of 1000 FE).").define("Shorten Power Bar Values", true);
        SHORTEN_TANK_GUI_VALUES = CLIENT_BUILDER.comment("When displaying larger numbers on a tooltip for a tank you hovered over, change the units to keep the numbers small (eg 1 B instead of 1000 mB).").define("Shorten Tank Tooltip Values", true);
        CLIENT_BUILDER.pop();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        Config.buildCommonConfig();
        Config.buildClientConfig();
    }
}

