/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolingRecipe
extends VERecipe {
    public static final RecipeType<ToolingRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.TOOLING.get();
    public static final Serializer SERIALIZER = new Serializer();
    protected Lazy<ArrayList<Item>> bits;
    protected Lazy<ArrayList<Item>> basesAndBits;
    protected Lazy<ArrayList<Item>> bases;
    public final ResourceLocation recipeId;
    public Lazy<Ingredient> ingredient;
    public ItemStack result;
    protected boolean usesTagKey;
    protected String tagKeyString;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    public ToolingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    @Override
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.TOOLING_STATION_BLOCK.get());
    }

    public ArrayList<Item> getBits() {
        return (ArrayList)this.bits.get();
    }

    public ArrayList<Item> getBasesAndBits() {
        return (ArrayList)this.basesAndBits.get();
    }

    public ArrayList<Item> getBases() {
        return (ArrayList)this.bases.get();
    }

    public static class Serializer
    implements RecipeSerializer<ToolingRecipe> {
        public ToolingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ToolingRecipe recipe = new ToolingRecipe(recipeId);
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)json.get("ingredient")));
            recipe.bits = Lazy.of(() -> {
                ArrayList<Item> items = new ArrayList<Item>();
                for (ItemStack item : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                    items.add(item.m_41720_());
                }
                return items;
            });
            JsonObject toolBase = json.get("tool_base").getAsJsonObject();
            if (toolBase.has("tag") && !toolBase.has("item")) {
                recipe.usesTagKey = true;
                ResourceLocation toolBaseResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)toolBase, (String)"tag", (String)"minecraft:air"), (char)':');
                recipe.tagKeyString = toolBaseResourceLocation.toString();
                recipe.bases = TagUtil.getLazyItems(toolBaseResourceLocation);
            } else if (!toolBase.has("tag") && toolBase.has("item")) {
                recipe.usesTagKey = false;
                ResourceLocation secondInputResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)toolBase, (String)"item", (String)"minecraft:air"), (char)':');
                recipe.bases = Lazy.of(() -> {
                    ArrayList<Item> items = new ArrayList<Item>();
                    items.add(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(secondInputResourceLocation)).m_41720_());
                    return items;
                });
            } else {
                throw new JsonSyntaxException("Bad syntax for the Tooling Recipe");
            }
            recipe.basesAndBits = RecipeUtil.createLazyAnthology(recipe.bases, recipe.bits);
            ResourceLocation itemResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            recipe.result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemResourceLocation));
            return recipe;
        }

        @Nullable
        public ToolingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i;
            ToolingRecipe recipe = new ToolingRecipe(recipeId);
            recipe.usesTagKey = buffer.readBoolean();
            if (recipe.usesTagKey) {
                ResourceLocation itemTagLocation = buffer.m_130281_();
                recipe.bases = TagUtil.getLazyItems(itemTagLocation);
            } else {
                int basesSize = buffer.readInt();
                ArrayList<Item> tempBases = new ArrayList<Item>();
                for (i = 0; i < basesSize; ++i) {
                    tempBases.add(buffer.m_130267_().m_41720_());
                }
                recipe.bases = Lazy.of(() -> tempBases);
            }
            int bitsSize = buffer.readInt();
            ArrayList<Item> bitList = new ArrayList<Item>();
            for (i = 0; i < bitsSize; ++i) {
                bitList.add(buffer.m_130267_().m_41720_());
            }
            recipe.bits = Lazy.of(() -> bitList);
            recipe.basesAndBits = RecipeUtil.createLazyAnthology(recipe.bases, recipe.bits);
            recipe.result = buffer.m_130267_();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, ToolingRecipe recipe) {
            buffer.writeBoolean(recipe.usesTagKey);
            if (recipe.usesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((ArrayList)recipe.bases.get()).size());
                ((ArrayList)recipe.bases.get()).forEach(item -> buffer.m_130055_(new ItemStack((ItemLike)item)));
            }
            buffer.writeInt(((ArrayList)recipe.bits.get()).size());
            ((ArrayList)recipe.bits.get()).forEach(item -> buffer.m_130055_(new ItemStack((ItemLike)item)));
            buffer.m_130055_(recipe.getResult());
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

