/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.tools.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class StirlingGeneratorRecipe
extends VERecipe {
    public static final RecipeType<StirlingGeneratorRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.STIRLING.get();
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation recipeId;
    public Lazy<Ingredient> ingredient;
    public int ingredientCount;
    public ItemStack result;
    private int energyPerTick;
    private int processTime;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public StirlingGeneratorRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    @Override
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.STIRLING_GENERATOR_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<StirlingGeneratorRecipe> {
        public StirlingGeneratorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            StirlingGeneratorRecipe recipe = new StirlingGeneratorRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            recipe.energyPerTick = GsonHelper.m_13824_((JsonObject)json, (String)"energy_per_tick", (int)((Integer)Config.STIRLING_GENERATOR_GENERATE.get()));
            recipe.result = new ItemStack((ItemLike)Items.f_42446_);
            return recipe;
        }

        @Nullable
        public StirlingGeneratorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            StirlingGeneratorRecipe recipe = new StirlingGeneratorRecipe(recipeId);
            recipe.ingredientCount = buffer.readByte();
            recipe.processTime = buffer.readInt();
            recipe.energyPerTick = buffer.readInt();
            recipe.result = buffer.m_130267_();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, StirlingGeneratorRecipe recipe) {
            buffer.writeByte(recipe.getIngredientCount());
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.energyPerTick);
            buffer.m_130055_(recipe.result);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

