/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SawmillingRecipe
extends VERecipe {
    public static final RecipeType<SawmillingRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.SAWMILLING.get();
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation recipeId;
    public Lazy<Ingredient> ingredient;
    public int ingredientCount;
    public ItemStack result;
    public ItemStack secondResult;
    private int processTime;
    private int outputAmount;
    private int secondAmount;
    private FluidStack outputFluid;
    private boolean isLogRecipe;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public SawmillingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getRngItem() {
        return this.secondResult;
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public int getSecondAmount() {
        return this.secondAmount;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid.copy();
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.SAWMILL_BLOCK.get());
    }

    public boolean isLogRecipe() {
        return this.isLogRecipe;
    }

    public static class Serializer
    implements RecipeSerializer<SawmillingRecipe> {
        public SawmillingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            SawmillingRecipe recipe = new SawmillingRecipe(recipeId);
            recipe.isLogRecipe = GsonHelper.m_13855_((JsonObject)json, (String)"auto_log_to_plank", (boolean)false);
            if (recipe.isLogRecipe) {
                return recipe;
            }
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            JsonObject resultData = json.get("result").getAsJsonObject();
            ResourceLocation itemResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)resultData, (String)"item", (String)"minecraft:air"), (char)':');
            int itemAmount = GsonHelper.m_13824_((JsonObject)resultData, (String)"count", (int)1);
            recipe.result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemResourceLocation));
            recipe.outputAmount = itemAmount;
            JsonObject secondResultData = json.get("second_result").getAsJsonObject();
            ResourceLocation secondResultResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)secondResultData, (String)"item", (String)"minecraft:air"), (char)':');
            int secondResultAmount = GsonHelper.m_13824_((JsonObject)secondResultData, (String)"count", (int)0);
            recipe.secondResult = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(secondResultResourceLocation));
            recipe.secondAmount = secondResultAmount;
            JsonObject outputFluid = json.get("output_fluid").getAsJsonObject();
            ResourceLocation outputFluidRL = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)outputFluid, (String)"fluid", (String)"minecraft:air"), (char)':');
            int fluidAmount = GsonHelper.m_13824_((JsonObject)outputFluid, (String)"amount", (int)0);
            recipe.outputFluid = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(outputFluidRL)), fluidAmount);
            return recipe;
        }

        @Nullable
        public SawmillingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            SawmillingRecipe recipe = new SawmillingRecipe(recipeId);
            recipe.isLogRecipe = buffer.readBoolean();
            if (!recipe.isLogRecipe) {
                recipe.ingredientCount = buffer.readByte();
                recipe.result = buffer.m_130267_();
                recipe.processTime = buffer.readInt();
                recipe.outputAmount = buffer.readInt();
                recipe.secondResult = buffer.m_130267_();
                recipe.secondAmount = buffer.readInt();
                recipe.outputFluid = buffer.readFluidStack();
                Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                recipe.ingredient = Lazy.of(() -> tempIngredient);
            }
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, SawmillingRecipe recipe) {
            buffer.writeBoolean(recipe.isLogRecipe);
            if (!recipe.isLogRecipe) {
                buffer.writeByte(recipe.getIngredientCount());
                buffer.m_130055_(recipe.getResult());
                buffer.writeInt(recipe.processTime);
                buffer.writeInt(recipe.outputAmount);
                buffer.m_130055_(recipe.secondResult);
                buffer.writeInt(recipe.secondAmount);
                buffer.writeFluidStack(recipe.outputFluid);
                ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
            }
        }
    }
}

