/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class IndustrialBlastingRecipe
extends VERecipe {
    protected Lazy<ArrayList<Item>> ingredientList;
    public Lazy<ArrayList<Item>> ingredientListIncludingSeconds;
    public Lazy<ArrayList<Item>> onlySecondInput;
    public final ResourceLocation recipeId;
    private int processTime;
    private int minimumHeat;
    private int secondInputAmount;
    private int outputAmount;
    protected boolean usesTagKey;
    protected String tagKeyString;
    Lazy<Integer> tempIngredientCount;
    public static final RecipeType<IndustrialBlastingRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.INDUSTRIAL_BLASTING.get();
    public static final Serializer SERIALIZER = new Serializer();
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public IndustrialBlastingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    @Deprecated
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount != 0 ? this.ingredientCount : ((Integer)this.tempIngredientCount.get() > 0 ? (Integer)this.tempIngredientCount.get() : 1);
    }

    public int getMinimumHeat() {
        return this.minimumHeat;
    }

    public int getSecondInputAmount() {
        return this.secondInputAmount;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public ArrayList<Item> getFirstInputAsList() {
        if (this.ingredientCount == 0) {
            this.ingredientCount = (Integer)this.tempIngredientCount.get() > 0 ? (Integer)this.tempIngredientCount.get() : 1;
        }
        return (ArrayList)this.ingredientList.get();
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.BLAST_FURNACE_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<IndustrialBlastingRecipe> {
        public IndustrialBlastingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            IndustrialBlastingRecipe recipe = new IndustrialBlastingRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            recipe.tempIngredientCount = Lazy.of(() -> GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1));
            recipe.ingredientList = Lazy.of(() -> {
                ArrayList<Item> temp = new ArrayList<Item>();
                for (ItemStack item : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                    temp.add(item.m_41720_());
                }
                return temp;
            });
            JsonObject secondInput = json.get("second_input").getAsJsonObject();
            if (secondInput.has("tag") && !secondInput.has("item")) {
                int secondInputAmount;
                secondInputResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)secondInput, (String)"tag", (String)"minecraft:air"), (char)':');
                recipe.secondInputAmount = secondInputAmount = GsonHelper.m_13824_((JsonObject)secondInput, (String)"count", (int)1);
                recipe.usesTagKey = true;
                recipe.tagKeyString = secondInputResourceLocation.toString();
                recipe.onlySecondInput = TagUtil.getLazyItems(secondInputResourceLocation);
            } else if (!secondInput.has("tag") && secondInput.has("item")) {
                int secondInputAmount;
                recipe.usesTagKey = false;
                secondInputResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)secondInput, (String)"item", (String)"minecraft:air"), (char)':');
                recipe.secondInputAmount = secondInputAmount = GsonHelper.m_13824_((JsonObject)secondInput, (String)"count", (int)1);
                recipe.onlySecondInput = Lazy.of(() -> {
                    ArrayList<Item> items = new ArrayList<Item>();
                    items.add(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(secondInputResourceLocation)).m_41720_());
                    return items;
                });
            } else {
                throw new JsonSyntaxException("Bad syntax for the Industrial Blasting Recipe");
            }
            recipe.ingredientListIncludingSeconds = RecipeUtil.createLazyAnthology(recipe.ingredientList, recipe.onlySecondInput);
            ResourceLocation itemResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            recipe.outputAmount = GsonHelper.m_13824_((JsonObject)json.get("result").getAsJsonObject(), (String)"count", (int)1);
            recipe.result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemResourceLocation));
            recipe.minimumHeat = GsonHelper.m_13824_((JsonObject)json, (String)"minimum_heat_kelvin", (int)300);
            return recipe;
        }

        @Nullable
        public IndustrialBlastingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i;
            IndustrialBlastingRecipe recipe = new IndustrialBlastingRecipe(recipeId);
            recipe.usesTagKey = buffer.readBoolean();
            if (recipe.usesTagKey) {
                ResourceLocation itemTagLocation = buffer.m_130281_();
                recipe.onlySecondInput = TagUtil.getLazyItems(itemTagLocation);
            } else {
                int secondListSize = buffer.readInt();
                ArrayList<Item> secondInputs = new ArrayList<Item>();
                for (i = 0; i < secondListSize; ++i) {
                    secondInputs.add(buffer.m_130267_().m_41720_());
                }
                recipe.onlySecondInput = Lazy.of(() -> secondInputs);
            }
            ArrayList<Item> firstInputList = new ArrayList<Item>();
            int firstInputSize = buffer.readInt();
            for (i = 0; i < firstInputSize; ++i) {
                ItemStack readStack = buffer.m_130267_();
                firstInputList.add(readStack.m_41720_());
                recipe.ingredientCount = readStack.m_41613_();
            }
            recipe.ingredientList = Lazy.of(() -> firstInputList);
            recipe.secondInputAmount = buffer.readInt();
            recipe.result = buffer.m_130267_();
            recipe.processTime = buffer.readInt();
            recipe.outputAmount = buffer.readInt();
            recipe.minimumHeat = buffer.readInt();
            recipe.ingredientCount = buffer.readInt();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            recipe.ingredientListIncludingSeconds = RecipeUtil.createLazyAnthology(recipe.ingredientList, recipe.onlySecondInput);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, IndustrialBlastingRecipe recipe) {
            buffer.writeBoolean(recipe.usesTagKey);
            if (recipe.usesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((ArrayList)recipe.onlySecondInput.get()).size());
                ((ArrayList)recipe.onlySecondInput.get()).forEach(item -> buffer.m_130055_(new ItemStack((ItemLike)item)));
            }
            ArrayList firstInputList = (ArrayList)recipe.ingredientList.get();
            int firstInputSize = firstInputList.size();
            buffer.writeInt(firstInputSize);
            for (Item item2 : firstInputList) {
                buffer.m_130055_(new ItemStack((ItemLike)item2, recipe.ingredientCount > 0 ? recipe.ingredientCount : ((Integer)recipe.tempIngredientCount.get() > 0 ? (Integer)recipe.tempIngredientCount.get() : 1)));
            }
            buffer.writeInt(recipe.secondInputAmount);
            buffer.m_130055_(recipe.getResult());
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.outputAmount);
            buffer.writeInt(recipe.minimumHeat);
            buffer.writeInt(recipe.ingredientCount > 0 ? recipe.ingredientCount : ((Integer)recipe.tempIngredientCount.get() > 0 ? (Integer)recipe.tempIngredientCount.get() : 1));
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

