/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class HydroponicIncubatorRecipe
extends VEFluidRecipe {
    public static final RecipeType<VEFluidRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.HYDROPONIC_INCUBATING.get();
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int processTime;
    private Lazy<FluidStack> inputFluid;
    private ItemStack result;
    private ItemStack rngResult0;
    private ItemStack rngResult1;
    private ItemStack rngResult2;
    private int inputAmount;
    private int outputAmount;
    private int outputRngAmount0;
    private int outputRngAmount1;
    private int outputRngAmount2;
    private float chance0;
    private float chance1;
    private float chance2;

    public HydroponicIncubatorRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public List<Integer> getAmounts() {
        return null;
    }

    public FluidStack getInputFluid() {
        return (FluidStack)this.inputFluid.get();
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    @Deprecated
    public ItemStack getResultItem() {
        return this.getResult();
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<VEFluidRecipe> m_6671_() {
        return RECIPE_TYPE;
    }

    @Override
    public ArrayList<Item> getIngredientList() {
        return null;
    }

    @Override
    public List<FluidStack> getFluids() {
        return (List)this.fluidInputList.get();
    }

    @Override
    public List<Fluid> getRawFluids() {
        return (List)this.rawFluidInputList.get();
    }

    @Override
    public List<ItemStack> getResults() {
        return List.of(this.result.m_41777_(), this.rngResult0.m_41777_(), this.rngResult1.m_41777_(), this.rngResult2.m_41777_());
    }

    public List<Item> getResultItems() {
        return List.of(this.result.m_41720_(), this.rngResult0.m_41720_(), this.rngResult1.m_41720_(), this.rngResult2.m_41720_());
    }

    @Override
    public int getOutputAmount() {
        return this.outputAmount;
    }

    public int getOutputRngAmount0() {
        return this.outputRngAmount0;
    }

    public int getOutputRngAmount1() {
        return this.outputRngAmount1;
    }

    public int getOutputRngAmount2() {
        return this.outputRngAmount2;
    }

    @Override
    public FluidStack getOutputFluid() {
        return null;
    }

    @Override
    public int getProcessTime() {
        return this.processTime;
    }

    @Override
    public int getInputAmount() {
        return this.inputAmount;
    }

    public ItemStack getRngItemSlot0() {
        return this.rngResult0;
    }

    public ItemStack getRngItemSlot1() {
        return this.rngResult1;
    }

    public ItemStack getRngItemSlot2() {
        return this.rngResult2;
    }

    public float getChance0() {
        return this.chance0;
    }

    public float getChance1() {
        return this.chance1;
    }

    public float getChance2() {
        return this.chance2;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.HYDROPONIC_INCUBATOR_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<HydroponicIncubatorRecipe> {
        public HydroponicIncubatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            HydroponicIncubatorRecipe recipe = new HydroponicIncubatorRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            JsonObject inputFluid = json.get("input_fluid").getAsJsonObject();
            recipe.inputAmount = GsonHelper.m_13824_((JsonObject)inputFluid, (String)"amount", (int)0);
            if (inputFluid.has("tag") && !inputFluid.has("fluid")) {
                ResourceLocation fluidTagLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"tag", (String)"minecraft:air"), (char)':');
                RecipeUtil.setupFluidLazyArrayInputsUsingTags(recipe, fluidTagLocation, recipe.inputAmount);
            } else if (inputFluid.has("fluid") && !inputFluid.has("tag")) {
                ResourceLocation fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"fluid", (String)"minecraft:empty"), (char)':');
                RecipeUtil.setupFluidLazyArrayInputsWithFluid(recipe, fluidResourceLocation, recipe.inputAmount);
            } else {
                throw new JsonSyntaxException("Bad syntax for the Hydroponic Incubator recipe, input_fluid must be tag or fluid");
            }
            ResourceLocation itemResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int itemAmount = GsonHelper.m_13824_((JsonObject)json.get("result").getAsJsonObject(), (String)"count", (int)1);
            recipe.result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemResourceLocation));
            recipe.outputAmount = itemAmount;
            ResourceLocation rngResourceLocation0 = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng_slot_0").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount0 = GsonHelper.m_13824_((JsonObject)json.get("rng_slot_0").getAsJsonObject(), (String)"count", (int)0);
            float rngChance0 = GsonHelper.m_13820_((JsonObject)json.get("rng_slot_0").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult0 = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation0));
            recipe.outputRngAmount0 = rngAmount0;
            recipe.chance0 = rngChance0;
            ResourceLocation rngResourceLocation1 = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng_slot_1").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount1 = GsonHelper.m_13824_((JsonObject)json.get("rng_slot_1").getAsJsonObject(), (String)"count", (int)0);
            float rngChance1 = GsonHelper.m_13820_((JsonObject)json.get("rng_slot_1").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult1 = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation1));
            recipe.outputRngAmount1 = rngAmount1;
            recipe.chance1 = rngChance1;
            ResourceLocation rngResourceLocation2 = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng_slot_2").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount2 = GsonHelper.m_13824_((JsonObject)json.get("rng_slot_2").getAsJsonObject(), (String)"count", (int)0);
            float rngChance2 = GsonHelper.m_13820_((JsonObject)json.get("rng_slot_2").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult2 = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation2));
            recipe.outputRngAmount2 = rngAmount2;
            recipe.chance2 = rngChance2;
            return recipe;
        }

        @Nullable
        public HydroponicIncubatorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            HydroponicIncubatorRecipe recipe = new HydroponicIncubatorRecipe(recipeId);
            recipe.inputAmount = buffer.readInt();
            recipe.fluidUsesTagKey = buffer.readBoolean();
            if (recipe.fluidUsesTagKey) {
                ResourceLocation fluidTagLocation = buffer.m_130281_();
                recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, recipe.inputAmount);
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else {
                int inputArraySize = buffer.readInt();
                recipe.inputArraySize = Lazy.of(() -> inputArraySize);
                ArrayList<Fluid> fluids = new ArrayList<Fluid>();
                ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
                for (int i = 0; i < inputArraySize; ++i) {
                    FluidStack serverFluid = buffer.readFluidStack();
                    fluidStacks.add(serverFluid.copy());
                    fluids.add(serverFluid.getRawFluid());
                }
                recipe.fluidInputList = Lazy.of(() -> fluidStacks);
                recipe.rawFluidInputList = Lazy.of(() -> fluids);
            }
            recipe.ingredientCount = buffer.readInt();
            recipe.result = buffer.m_130267_();
            recipe.processTime = buffer.readInt();
            recipe.outputAmount = buffer.readInt();
            recipe.rngResult0 = buffer.m_130267_();
            recipe.outputRngAmount0 = buffer.readInt();
            recipe.chance0 = buffer.readFloat();
            recipe.rngResult1 = buffer.m_130267_();
            recipe.outputRngAmount1 = buffer.readInt();
            recipe.chance1 = buffer.readFloat();
            recipe.rngResult2 = buffer.m_130267_();
            recipe.outputRngAmount2 = buffer.readInt();
            recipe.chance2 = buffer.readFloat();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, HydroponicIncubatorRecipe recipe) {
            buffer.writeInt(recipe.inputAmount);
            buffer.writeBoolean(recipe.fluidUsesTagKey);
            if (recipe.fluidUsesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((Integer)recipe.inputArraySize.get()).intValue());
                for (int i = 0; i < (Integer)recipe.inputArraySize.get(); ++i) {
                    buffer.writeFluidStack(((FluidStack)((ArrayList)recipe.fluidInputList.get()).get(i)).copy());
                }
            }
            buffer.writeInt(recipe.ingredientCount);
            buffer.m_130055_(recipe.getResult());
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.outputAmount);
            buffer.m_130055_(recipe.rngResult0);
            buffer.writeInt(recipe.outputRngAmount0);
            buffer.writeFloat(recipe.chance0);
            buffer.m_130055_(recipe.rngResult1);
            buffer.writeInt(recipe.outputRngAmount1);
            buffer.writeFloat(recipe.chance1);
            buffer.m_130055_(recipe.rngResult2);
            buffer.writeInt(recipe.outputRngAmount2);
            buffer.writeFloat(recipe.chance2);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

