/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidMixerRecipe
extends VEFluidRecipe {
    public static final RecipeType<VEFluidRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.FLUID_MIXING.get();
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int processTime;
    public boolean secondFluidUsesTagKey;
    public String secondTagKeyString;
    public Lazy<ArrayList<FluidStack>> secondFluidInputList;
    public Lazy<ArrayList<Fluid>> secondRawFluidInputList;
    public Lazy<Integer> secondInputArraySize;
    private FluidStack result;
    private int firstInputAmount;
    private int secondInputAmount;
    private int outputAmount;

    @Override
    public ArrayList<Item> getIngredientList() {
        return null;
    }

    public FluidMixerRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    @Deprecated
    public ItemStack getResult() {
        return new ItemStack((ItemLike)this.result.getFluid().m_6859_());
    }

    @Override
    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> f = new ArrayList<FluidStack>();
        f.add(this.getOutputFluid());
        return f;
    }

    @Override
    public List<Fluid> getRawFluids() {
        ArrayList<Fluid> f = new ArrayList<Fluid>();
        f.add(this.getOutputFluid().getRawFluid());
        return f;
    }

    @Override
    public List<ItemStack> getResults() {
        return null;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.result.copy();
    }

    @Override
    public List<Integer> getAmounts() {
        return null;
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    @Deprecated
    public ItemStack getResultItem() {
        return this.getResult();
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<VEFluidRecipe> m_6671_() {
        return RECIPE_TYPE;
    }

    @Override
    public int getOutputAmount() {
        return this.outputAmount;
    }

    @Override
    public int getInputAmount() {
        return this.firstInputAmount;
    }

    @Override
    public int getProcessTime() {
        return this.processTime;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.FLUID_MIXER_BLOCK.get());
    }

    public int getSecondInputAmount() {
        return this.secondInputAmount;
    }

    protected static void setupSecondFluidLazyArrayInputsUsingTags(FluidMixerRecipe recipe, ResourceLocation fluidTagLocation, int fluidAmount) {
        recipe.secondFluidUsesTagKey = true;
        recipe.secondTagKeyString = fluidTagLocation.toString();
        recipe.secondRawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
        recipe.secondFluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, fluidAmount);
        recipe.secondInputArraySize = Lazy.of(() -> ((ArrayList)recipe.secondFluidInputList.get()).size());
    }

    protected static void setupSecondFluidLazyArrayInputsWithFluid(FluidMixerRecipe recipe, ResourceLocation fluidResourceLocation, int fluidAmount) {
        recipe.secondFluidUsesTagKey = false;
        recipe.secondFluidInputList = Lazy.of(() -> {
            ArrayList<FluidStack> temp = new ArrayList<FluidStack>();
            temp.add(new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation)), fluidAmount));
            return temp;
        });
        recipe.secondRawFluidInputList = Lazy.of(() -> {
            ArrayList<Fluid> temp = new ArrayList<Fluid>();
            temp.add((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation));
            return temp;
        });
        recipe.secondInputArraySize = Lazy.of(() -> 1);
    }

    public static class Serializer
    implements RecipeSerializer<FluidMixerRecipe> {
        public FluidMixerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ResourceLocation fluidResourceLocation;
            ResourceLocation fluidTagLocation;
            FluidMixerRecipe recipe = new FluidMixerRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            JsonObject inputFluid = json.get("first_input_fluid").getAsJsonObject();
            recipe.firstInputAmount = GsonHelper.m_13824_((JsonObject)inputFluid, (String)"amount", (int)0);
            if (inputFluid.has("tag") && !inputFluid.has("fluid")) {
                fluidTagLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"tag", (String)"minecraft:air"), (char)':');
                RecipeUtil.setupFluidLazyArrayInputsUsingTags(recipe, fluidTagLocation, recipe.firstInputAmount);
            } else if (inputFluid.has("fluid") && !inputFluid.has("tag")) {
                fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"fluid", (String)"minecraft:empty"), (char)':');
                RecipeUtil.setupFluidLazyArrayInputsWithFluid(recipe, fluidResourceLocation, recipe.firstInputAmount);
            } else {
                throw new JsonSyntaxException("Bad syntax for the Fluid Mixer recipe, input_fluid must be tag or fluid");
            }
            inputFluid = json.get("second_input_fluid").getAsJsonObject();
            recipe.secondInputAmount = GsonHelper.m_13824_((JsonObject)inputFluid, (String)"amount", (int)0);
            if (inputFluid.has("tag") && !inputFluid.has("fluid")) {
                fluidTagLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"tag", (String)"minecraft:air"), (char)':');
                FluidMixerRecipe.setupSecondFluidLazyArrayInputsUsingTags(recipe, fluidTagLocation, recipe.secondInputAmount);
            } else if (inputFluid.has("fluid") && !inputFluid.has("tag")) {
                fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"fluid", (String)"minecraft:empty"), (char)':');
                FluidMixerRecipe.setupSecondFluidLazyArrayInputsWithFluid(recipe, fluidResourceLocation, recipe.secondInputAmount);
            } else {
                throw new JsonSyntaxException("Bad syntax for the Fluid Mixer recipe, input_fluid must be tag or fluid");
            }
            ResourceLocation bucketResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("result").getAsJsonObject(), (String)"fluid", (String)"minecraft:empty"), (char)':');
            int firstOutputFluidAmount = GsonHelper.m_13824_((JsonObject)json.get("result").getAsJsonObject(), (String)"amount", (int)0);
            recipe.result = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(bucketResourceLocation)), firstOutputFluidAmount);
            recipe.outputAmount = firstOutputFluidAmount;
            return recipe;
        }

        @Nullable
        public FluidMixerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidStack serverFluid;
            int i;
            ArrayList<FluidStack> fluidStacks;
            ArrayList<Fluid> fluids;
            ResourceLocation fluidTagLocation;
            FluidMixerRecipe recipe = new FluidMixerRecipe(recipeId);
            recipe.ingredientCount = buffer.readByte();
            recipe.firstInputAmount = buffer.readInt();
            recipe.secondInputAmount = buffer.readInt();
            recipe.fluidUsesTagKey = buffer.readBoolean();
            if (recipe.fluidUsesTagKey) {
                fluidTagLocation = buffer.m_130281_();
                recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, recipe.firstInputAmount);
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else {
                int inputArraySize = buffer.readInt();
                recipe.inputArraySize = Lazy.of(() -> inputArraySize);
                fluids = new ArrayList<Fluid>();
                fluidStacks = new ArrayList<FluidStack>();
                for (i = 0; i < inputArraySize; ++i) {
                    serverFluid = buffer.readFluidStack();
                    fluidStacks.add(serverFluid.copy());
                    fluids.add(serverFluid.getRawFluid());
                }
                recipe.fluidInputList = Lazy.of(() -> fluidStacks);
                recipe.rawFluidInputList = Lazy.of(() -> fluids);
            }
            recipe.secondFluidUsesTagKey = buffer.readBoolean();
            if (recipe.secondFluidUsesTagKey) {
                fluidTagLocation = buffer.m_130281_();
                recipe.secondRawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.secondFluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, recipe.secondInputAmount);
                recipe.secondInputArraySize = Lazy.of(() -> ((ArrayList)recipe.secondFluidInputList.get()).size());
            } else {
                int inputArraySize = buffer.readInt();
                recipe.secondInputArraySize = Lazy.of(() -> inputArraySize);
                fluids = new ArrayList();
                fluidStacks = new ArrayList();
                for (i = 0; i < inputArraySize; ++i) {
                    serverFluid = buffer.readFluidStack();
                    fluidStacks.add(serverFluid.copy());
                    fluids.add(serverFluid.getRawFluid());
                }
                recipe.secondFluidInputList = Lazy.of(() -> fluidStacks);
                recipe.secondRawFluidInputList = Lazy.of(() -> fluids);
            }
            recipe.result = buffer.readFluidStack();
            recipe.processTime = buffer.readInt();
            recipe.outputAmount = buffer.readInt();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidMixerRecipe recipe) {
            int i;
            buffer.writeByte(recipe.getIngredientCount());
            buffer.writeInt(recipe.firstInputAmount);
            buffer.writeInt(recipe.secondInputAmount);
            buffer.writeBoolean(recipe.fluidUsesTagKey);
            if (recipe.fluidUsesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((Integer)recipe.inputArraySize.get()).intValue());
                for (i = 0; i < (Integer)recipe.inputArraySize.get(); ++i) {
                    buffer.writeFluidStack(((FluidStack)((ArrayList)recipe.fluidInputList.get()).get(i)).copy());
                }
            }
            buffer.writeBoolean(recipe.secondFluidUsesTagKey);
            if (recipe.secondFluidUsesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.secondTagKeyString));
            } else {
                buffer.writeInt(((Integer)recipe.secondInputArraySize.get()).intValue());
                for (i = 0; i < (Integer)recipe.secondInputArraySize.get(); ++i) {
                    buffer.writeFluidStack(((FluidStack)((ArrayList)recipe.secondFluidInputList.get()).get(i)).copy());
                }
            }
            buffer.writeFluidStack(recipe.result);
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.outputAmount);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

