/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class ElectrolyzerRecipe
extends VERecipe {
    public static final RecipeType<ElectrolyzerRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.ELECTROLYZING.get();
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation recipeId;
    public Lazy<Ingredient> ingredient;
    public int ingredientCount;
    public ItemStack result;
    private ItemStack rngResult0;
    private ItemStack rngResult1;
    private ItemStack rngResult2;
    private int processTime;
    private int outputAmount;
    private int outputRngAmount0;
    private int outputRngAmount1;
    private int outputRngAmount2;
    private float chance0;
    private float chance1;
    private float chance2;
    private int usesBucket;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public ElectrolyzerRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getRngItemSlot0() {
        return this.rngResult0;
    }

    public ItemStack getRngItemSlot1() {
        return this.rngResult1;
    }

    public ItemStack getRngItemSlot2() {
        return this.rngResult2;
    }

    public float getChance0() {
        return this.chance0;
    }

    public float getChance1() {
        return this.chance1;
    }

    public float getChance2() {
        return this.chance2;
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public int getOutputRngAmount0() {
        return this.outputRngAmount0;
    }

    public int getOutputRngAmount1() {
        return this.outputRngAmount1;
    }

    public int getOutputRngAmount2() {
        return this.outputRngAmount2;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int needsBuckets() {
        return this.usesBucket;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.ELECTROLYZER_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<ElectrolyzerRecipe> {
        public ElectrolyzerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ElectrolyzerRecipe recipe = new ElectrolyzerRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            ResourceLocation itemResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int itemAmount = GsonHelper.m_13824_((JsonObject)json.get("result").getAsJsonObject(), (String)"count", (int)1);
            int bucketNeeded = GsonHelper.m_13824_((JsonObject)json.get("result").getAsJsonObject(), (String)"consumes_bucket", (int)0);
            recipe.result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemResourceLocation));
            recipe.outputAmount = itemAmount;
            recipe.usesBucket = bucketNeeded;
            ResourceLocation rngResourceLocation0 = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng_slot_0").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount0 = GsonHelper.m_13824_((JsonObject)json.get("rng_slot_0").getAsJsonObject(), (String)"count", (int)0);
            float rngChance0 = GsonHelper.m_13820_((JsonObject)json.get("rng_slot_0").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult0 = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation0));
            recipe.outputRngAmount0 = rngAmount0;
            recipe.chance0 = rngChance0;
            ResourceLocation rngResourceLocation1 = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng_slot_1").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount1 = GsonHelper.m_13824_((JsonObject)json.get("rng_slot_1").getAsJsonObject(), (String)"count", (int)0);
            float rngChance1 = GsonHelper.m_13820_((JsonObject)json.get("rng_slot_1").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult1 = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation1));
            recipe.outputRngAmount1 = rngAmount1;
            recipe.chance1 = rngChance1;
            ResourceLocation rngResourceLocation2 = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng_slot_2").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount2 = GsonHelper.m_13824_((JsonObject)json.get("rng_slot_2").getAsJsonObject(), (String)"count", (int)0);
            float rngChance2 = GsonHelper.m_13820_((JsonObject)json.get("rng_slot_2").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult2 = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation2));
            recipe.outputRngAmount2 = rngAmount2;
            recipe.chance2 = rngChance2;
            return recipe;
        }

        @Nullable
        public ElectrolyzerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ElectrolyzerRecipe recipe = new ElectrolyzerRecipe(recipeId);
            recipe.ingredientCount = buffer.readByte();
            recipe.result = buffer.m_130267_();
            recipe.processTime = buffer.readInt();
            recipe.outputAmount = buffer.readInt();
            recipe.usesBucket = buffer.readInt();
            recipe.rngResult0 = buffer.m_130267_();
            recipe.outputRngAmount0 = buffer.readInt();
            recipe.chance0 = buffer.readFloat();
            recipe.rngResult1 = buffer.m_130267_();
            recipe.outputRngAmount1 = buffer.readInt();
            recipe.chance1 = buffer.readFloat();
            recipe.rngResult2 = buffer.m_130267_();
            recipe.outputRngAmount2 = buffer.readInt();
            recipe.chance2 = buffer.readFloat();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, ElectrolyzerRecipe recipe) {
            buffer.writeByte(recipe.getIngredientCount());
            buffer.m_130055_(recipe.getResult());
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.outputAmount);
            buffer.writeInt(recipe.usesBucket);
            buffer.m_130055_(recipe.rngResult0);
            buffer.writeInt(recipe.outputRngAmount0);
            buffer.writeFloat(recipe.chance0);
            buffer.m_130055_(recipe.rngResult1);
            buffer.writeInt(recipe.outputRngAmount1);
            buffer.writeFloat(recipe.chance1);
            buffer.m_130055_(recipe.rngResult2);
            buffer.writeInt(recipe.outputRngAmount2);
            buffer.writeFloat(recipe.chance2);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

