/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.gson.JsonObject;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.climate.FluidClimateSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import oshi.util.tuples.Pair;

public class DimensionalLaserRecipe
extends VEFluidRecipe {
    public static final RecipeType<VEFluidRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.DIMENSIONAL_LASING.get();
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private FluidStack result;
    private Fluid fluid;
    private int maximumAmount;
    private int minimumAmount;
    private Pair<Float, Float> continentalnessRange;
    private Pair<Float, Float> erosionRange;
    private Pair<Float, Float> humidityRange;
    private Pair<Float, Float> temperatureRange;
    private FluidClimateSpawn fluidClimateSpawn;

    public DimensionalLaserRecipe() {
        this.recipeId = null;
    }

    public DimensionalLaserRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    @Deprecated
    public ItemStack getResult() {
        return new ItemStack((ItemLike)this.fluid.m_6859_());
    }

    @Override
    public FluidStack getOutputFluid() {
        return new FluidStack(this.fluid, 1000);
    }

    @Override
    public List<Integer> getAmounts() {
        return List.of(Integer.valueOf(this.minimumAmount), Integer.valueOf(this.maximumAmount));
    }

    public FluidStack getInputFluid() {
        return new FluidStack(this.fluid, 1000);
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    @Deprecated
    public ItemStack getResultItem() {
        return this.getResult();
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<VEFluidRecipe> m_6671_() {
        return RECIPE_TYPE;
    }

    @Override
    public ArrayList<Item> getIngredientList() {
        return null;
    }

    @Override
    public List<FluidStack> getFluids() {
        return List.of(new FluidStack(this.fluid, 1000));
    }

    @Override
    public List<Fluid> getRawFluids() {
        return List.of(this.fluid);
    }

    @Override
    public List<ItemStack> getResults() {
        return null;
    }

    @Override
    public int getOutputAmount() {
        return 0;
    }

    @Override
    public int getProcessTime() {
        return 0;
    }

    @Override
    public int getInputAmount() {
        return 0;
    }

    public FluidClimateSpawn getFluidClimateSpawn() {
        return this.fluidClimateSpawn;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.AQUEOULIZER_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<DimensionalLaserRecipe> {
        public DimensionalLaserRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            DimensionalLaserRecipe recipe = new DimensionalLaserRecipe(recipeId);
            ResourceLocation fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json, (String)"fluid", (String)"minecraft:air"), (char)':');
            recipe.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation);
            JsonObject amountsJson = json.get("amounts").getAsJsonObject();
            recipe.minimumAmount = GsonHelper.m_13824_((JsonObject)amountsJson, (String)"minimum", (int)1);
            recipe.maximumAmount = GsonHelper.m_13824_((JsonObject)amountsJson, (String)"maximum", (int)1);
            JsonObject spansJson = json.get("climate").getAsJsonObject();
            JsonObject continentalness = spansJson.get("continentalness").getAsJsonObject();
            float min = GsonHelper.m_13820_((JsonObject)continentalness, (String)"minimum", (float)0.0f);
            float max = GsonHelper.m_13820_((JsonObject)continentalness, (String)"maximum", (float)0.0f);
            recipe.continentalnessRange = new Pair((Object)Float.valueOf(min), (Object)Float.valueOf(max));
            JsonObject erosion = spansJson.get("erosion").getAsJsonObject();
            min = GsonHelper.m_13820_((JsonObject)erosion, (String)"minimum", (float)0.0f);
            max = GsonHelper.m_13820_((JsonObject)erosion, (String)"maximum", (float)0.0f);
            recipe.erosionRange = new Pair((Object)Float.valueOf(min), (Object)Float.valueOf(max));
            JsonObject humidity = spansJson.get("humidity").getAsJsonObject();
            min = GsonHelper.m_13820_((JsonObject)humidity, (String)"minimum", (float)0.0f);
            max = GsonHelper.m_13820_((JsonObject)humidity, (String)"maximum", (float)0.0f);
            recipe.humidityRange = new Pair((Object)Float.valueOf(min), (Object)Float.valueOf(max));
            JsonObject temperature = spansJson.get("temperature").getAsJsonObject();
            min = GsonHelper.m_13820_((JsonObject)temperature, (String)"minimum", (float)0.0f);
            max = GsonHelper.m_13820_((JsonObject)temperature, (String)"maximum", (float)0.0f);
            recipe.temperatureRange = new Pair((Object)Float.valueOf(min), (Object)Float.valueOf(max));
            recipe.fluidClimateSpawn = new FluidClimateSpawn(recipe.continentalnessRange, recipe.erosionRange, recipe.humidityRange, recipe.temperatureRange, recipe.fluid, recipe.minimumAmount, recipe.maximumAmount);
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42446_, 1)}));
            recipe.result = new FluidStack(Objects.requireNonNull(recipe.fluid), 1000);
            return recipe;
        }

        @Nullable
        public DimensionalLaserRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            DimensionalLaserRecipe recipe = new DimensionalLaserRecipe(recipeId);
            recipe.fluid = buffer.readFluidStack().getRawFluid();
            recipe.minimumAmount = buffer.readInt();
            recipe.maximumAmount = buffer.readInt();
            float tempA = buffer.readFloat();
            float tempB = buffer.readFloat();
            recipe.continentalnessRange = new Pair((Object)Float.valueOf(tempA), (Object)Float.valueOf(tempB));
            tempA = buffer.readFloat();
            tempB = buffer.readFloat();
            recipe.erosionRange = new Pair((Object)Float.valueOf(tempA), (Object)Float.valueOf(tempB));
            tempA = buffer.readFloat();
            tempB = buffer.readFloat();
            recipe.humidityRange = new Pair((Object)Float.valueOf(tempA), (Object)Float.valueOf(tempB));
            tempA = buffer.readFloat();
            tempB = buffer.readFloat();
            recipe.temperatureRange = new Pair((Object)Float.valueOf(tempA), (Object)Float.valueOf(tempB));
            recipe.fluidClimateSpawn = new FluidClimateSpawn(recipe.continentalnessRange, recipe.erosionRange, recipe.humidityRange, recipe.temperatureRange, recipe.fluid, recipe.minimumAmount, recipe.maximumAmount);
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42446_, 1)}));
            recipe.result = new FluidStack(recipe.fluid, 1000);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, DimensionalLaserRecipe recipe) {
            buffer.writeFluidStack(new FluidStack(recipe.fluid, 1000));
            buffer.writeInt(recipe.minimumAmount);
            buffer.writeInt(recipe.maximumAmount);
            buffer.writeFloat(((Float)recipe.continentalnessRange.getA()).floatValue());
            buffer.writeFloat(((Float)recipe.continentalnessRange.getB()).floatValue());
            buffer.writeFloat(((Float)recipe.erosionRange.getA()).floatValue());
            buffer.writeFloat(((Float)recipe.erosionRange.getB()).floatValue());
            buffer.writeFloat(((Float)recipe.humidityRange.getA()).floatValue());
            buffer.writeFloat(((Float)recipe.humidityRange.getB()).floatValue());
            buffer.writeFloat(((Float)recipe.temperatureRange.getA()).floatValue());
            buffer.writeFloat(((Float)recipe.temperatureRange.getB()).floatValue());
        }
    }
}

