/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class CrusherRecipe
extends VERecipe {
    public static final RecipeType<CrusherRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.CRUSHING.get();
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation recipeId;
    public Lazy<Ingredient> ingredient;
    public int ingredientCount;
    public ItemStack result;
    public ItemStack rngResult;
    private int processTime;
    private int outputAmount;
    private int outputRngAmount;
    private float chance;
    private int minExperience;
    private int maxExperience;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public CrusherRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getRngItem() {
        return this.rngResult;
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public int getOutputRngAmount() {
        return this.outputRngAmount;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getMinExperience() {
        return this.minExperience;
    }

    public int getMaxExperience() {
        return this.maxExperience;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.CRUSHER_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<CrusherRecipe> {
        public CrusherRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            CrusherRecipe recipe = new CrusherRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            ResourceLocation itemResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("result").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int itemAmount = GsonHelper.m_13824_((JsonObject)json.get("result").getAsJsonObject(), (String)"count", (int)1);
            recipe.result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemResourceLocation));
            recipe.outputAmount = itemAmount;
            ResourceLocation rngResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("rng").getAsJsonObject(), (String)"item", (String)"minecraft:air"), (char)':');
            int rngAmount = GsonHelper.m_13824_((JsonObject)json.get("rng").getAsJsonObject(), (String)"count", (int)0);
            float rngChance = GsonHelper.m_13820_((JsonObject)json.get("rng").getAsJsonObject(), (String)"chance", (float)0.0f);
            recipe.rngResult = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(rngResourceLocation));
            recipe.outputRngAmount = rngAmount;
            recipe.chance = rngChance;
            recipe.minExperience = GsonHelper.m_13824_((JsonObject)json.get("experience").getAsJsonObject(), (String)"minimum", (int)0);
            recipe.maxExperience = GsonHelper.m_13824_((JsonObject)json.get("experience").getAsJsonObject(), (String)"maximum", (int)0);
            return recipe;
        }

        @Nullable
        public CrusherRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CrusherRecipe recipe = new CrusherRecipe(recipeId);
            recipe.ingredientCount = buffer.readByte();
            recipe.result = buffer.m_130267_();
            recipe.processTime = buffer.readInt();
            recipe.outputAmount = buffer.readInt();
            recipe.rngResult = buffer.m_130267_();
            recipe.outputRngAmount = buffer.readInt();
            recipe.chance = buffer.readFloat();
            recipe.minExperience = buffer.readInt();
            recipe.maxExperience = buffer.readInt();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, CrusherRecipe recipe) {
            buffer.writeByte(recipe.getIngredientCount());
            buffer.m_130055_(recipe.getResult());
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.outputAmount);
            buffer.m_130055_(recipe.rngResult);
            buffer.writeInt(recipe.outputRngAmount);
            buffer.writeFloat(recipe.chance);
            buffer.writeInt(recipe.minExperience);
            buffer.writeInt(recipe.maxExperience);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

