/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe.CombustionGenerator;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CombustionGeneratorOxidizerRecipe
extends VERecipe {
    public static final RecipeType<CombustionGeneratorOxidizerRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.OXIDIZING.get();
    public static final Serializer SERIALIZER = new Serializer();
    public Lazy<ArrayList<Item>> ingredientList = RecipeUtil.getLazyItemsFromIngredient(this);
    public static ArrayList<CombustionGeneratorOxidizerRecipe> oxidizerRecipes = new ArrayList();
    public Lazy<ArrayList<FluidStack>> fluidInputList;
    public Lazy<ArrayList<Fluid>> rawFluidInputList;
    private final ResourceLocation recipeId;
    private int processTime;
    private Lazy<Integer> inputArraySize;
    private Lazy<FluidStack> inputFluid;
    public ItemStack result = new ItemStack((ItemLike)Items.f_42446_);
    protected boolean usesTagKey;
    protected String tagKeyString;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public CombustionGeneratorOxidizerRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public FluidStack getInputFluid() {
        return ((FluidStack)this.inputFluid.get()).copy();
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public static class Serializer
    implements RecipeSerializer<CombustionGeneratorOxidizerRecipe> {
        public CombustionGeneratorOxidizerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            CombustionGeneratorOxidizerRecipe recipe = new CombustionGeneratorOxidizerRecipe(recipeId);
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)json.get("ingredient")));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)json.get("ingredient").getAsJsonObject(), (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)1600);
            JsonObject inputFluid = json.get("input_fluid").getAsJsonObject();
            if (inputFluid.has("tag") && !inputFluid.has("fluid")) {
                recipe.usesTagKey = true;
                ResourceLocation fluidTagLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"tag", (String)"minecraft:air"), (char)':');
                recipe.tagKeyString = fluidTagLocation.toString();
                recipe.inputFluid = null;
                recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, 1000);
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else if (inputFluid.has("fluid") && !inputFluid.has("tag")) {
                recipe.usesTagKey = false;
                ResourceLocation fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"fluid", (String)"minecraft:empty"), (char)':');
                recipe.inputFluid = Lazy.of(() -> new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation)), 1000));
                recipe.fluidInputList = Lazy.of(() -> {
                    ArrayList<FluidStack> temp = new ArrayList<FluidStack>();
                    temp.add(new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation)), 1));
                    return temp;
                });
                recipe.rawFluidInputList = Lazy.of(() -> {
                    ArrayList<Fluid> temp = new ArrayList<Fluid>();
                    temp.add((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation));
                    return temp;
                });
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else {
                throw new JsonSyntaxException("Bad syntax for the Combustion Fuel recipe, input_fluid must be tag or fluid");
            }
            oxidizerRecipes.add(recipe);
            return recipe;
        }

        @Nullable
        public CombustionGeneratorOxidizerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CombustionGeneratorOxidizerRecipe recipe = new CombustionGeneratorOxidizerRecipe(recipeId);
            recipe.ingredientCount = buffer.readByte();
            recipe.processTime = buffer.readInt();
            recipe.usesTagKey = buffer.readBoolean();
            if (recipe.usesTagKey) {
                ResourceLocation fluidTagLocation = buffer.m_130281_();
                recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, 1000);
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else {
                int inputArraySize = buffer.readInt();
                recipe.inputArraySize = Lazy.of(() -> inputArraySize);
                ArrayList<Fluid> fluids = new ArrayList<Fluid>();
                ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
                for (int i = 0; i < inputArraySize; ++i) {
                    FluidStack serverFluid = buffer.readFluidStack();
                    fluidStacks.add(serverFluid.copy());
                    fluids.add(serverFluid.getRawFluid());
                }
                recipe.fluidInputList = Lazy.of(() -> fluidStacks);
                recipe.rawFluidInputList = Lazy.of(() -> fluids);
            }
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            if (!atomicBoolean.get()) {
                oxidizerRecipes.add(recipe);
            }
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            oxidizerRecipes.add(recipe);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, CombustionGeneratorOxidizerRecipe recipe) {
            buffer.writeByte(recipe.getIngredientCount());
            buffer.writeInt(recipe.processTime);
            buffer.writeBoolean(recipe.usesTagKey);
            if (recipe.usesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((Integer)recipe.inputArraySize.get()).intValue());
                for (int i = 0; i < (Integer)recipe.inputArraySize.get(); ++i) {
                    buffer.writeFluidStack(((FluidStack)((ArrayList)recipe.fluidInputList.get()).get(i)).copy());
                }
            }
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

