/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe.CombustionGenerator;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import oshi.util.tuples.Pair;

public class CombustionGeneratorFuelRecipe
extends VEFluidRecipe {
    public static final RecipeType<VEFluidRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.FUEL_COMBUSTION.get();
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int volumetricEnergy;
    @Deprecated
    private FluidStack inputFluid;
    private ItemStack result;
    public static ArrayList<Lazy<Pair<ArrayList<Fluid>, Integer>>> lazyFluidsWithVolumetricEnergy = new ArrayList();
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();

    public CombustionGeneratorFuelRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public CombustionGeneratorFuelRecipe() {
        this.recipeId = null;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Deprecated
    public FluidStack getInputFluid() {
        return this.inputFluid.copy();
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<VEFluidRecipe> m_6671_() {
        return RECIPE_TYPE;
    }

    @Override
    public ArrayList<Item> getIngredientList() {
        return (ArrayList)this.ingredientList.get();
    }

    @Override
    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> f = new ArrayList<FluidStack>();
        f.add(this.getOutputFluid());
        return f;
    }

    @Override
    public List<Fluid> getRawFluids() {
        ArrayList<Fluid> f = new ArrayList<Fluid>();
        f.add(this.getOutputFluid().getRawFluid());
        return f;
    }

    @Override
    public List<ItemStack> getResults() {
        ArrayList<ItemStack> s = new ArrayList<ItemStack>();
        s.add(this.getResult());
        return s;
    }

    @Override
    public int getInputAmount() {
        return 0;
    }

    @Override
    public int getOutputAmount() {
        return 0;
    }

    @Override
    public FluidStack getOutputFluid() {
        return new FluidStack(((BucketItem)this.result.m_41720_()).getFluid(), 250);
    }

    @Override
    public List<Integer> getAmounts() {
        return null;
    }

    @Override
    public int getProcessTime() {
        return this.getVolumetricEnergy();
    }

    public int getVolumetricEnergy() {
        return this.volumetricEnergy;
    }

    public static class Serializer
    implements RecipeSerializer<CombustionGeneratorFuelRecipe> {
        public CombustionGeneratorFuelRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            CombustionGeneratorFuelRecipe recipe = new CombustionGeneratorFuelRecipe(recipeId);
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)json.get("ingredient")));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)json.get("ingredient").getAsJsonObject(), (String)"count", (int)1);
            recipe.volumetricEnergy = GsonHelper.m_13824_((JsonObject)json.get("ingredient").getAsJsonObject(), (String)"volumetric_energy", (int)102400);
            JsonObject inputFluid = json.get("input_fluid").getAsJsonObject();
            if (inputFluid.has("tag") && !inputFluid.has("fluid")) {
                ResourceLocation fluidTagLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"tag", (String)"minecraft:air"), (char)':');
                recipe.inputFluid = null;
                RecipeUtil.setupFluidLazyArrayInputsUsingTags(recipe, fluidTagLocation, 1000);
            } else if (inputFluid.has("fluid") && !inputFluid.has("tag")) {
                ResourceLocation fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"fluid", (String)"minecraft:empty"), (char)':');
                recipe.inputFluid = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation)), 1000);
                RecipeUtil.setupFluidLazyArrayInputsWithFluid(recipe, fluidResourceLocation, 1000);
            } else {
                throw new JsonSyntaxException("Bad syntax for the Combustion Fuel recipe, input_fluid must be tag or fluid");
            }
            lazyFluidsWithVolumetricEnergy.add((Lazy<Pair<ArrayList<Fluid>, Integer>>)Lazy.of(() -> new Pair((Object)((ArrayList)recipe.rawFluidInputList.get()), (Object)recipe.volumetricEnergy)));
            recipe.result = new ItemStack((ItemLike)Items.f_42446_);
            return recipe;
        }

        @Nullable
        public CombustionGeneratorFuelRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CombustionGeneratorFuelRecipe recipe = new CombustionGeneratorFuelRecipe(recipeId);
            recipe.fluidUsesTagKey = buffer.readBoolean();
            if (recipe.fluidUsesTagKey) {
                ResourceLocation fluidTagLocation = buffer.m_130281_();
                recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, 1000);
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else {
                int inputArraySize = buffer.readInt();
                recipe.inputArraySize = Lazy.of(() -> inputArraySize);
                ArrayList<Fluid> fluids = new ArrayList<Fluid>();
                ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
                for (int i = 0; i < inputArraySize; ++i) {
                    FluidStack serverFluid = buffer.readFluidStack();
                    fluidStacks.add(serverFluid.copy());
                    fluids.add(serverFluid.getRawFluid());
                }
                recipe.fluidInputList = Lazy.of(() -> fluidStacks);
                recipe.rawFluidInputList = Lazy.of(() -> fluids);
            }
            recipe.ingredientCount = buffer.readInt();
            recipe.volumetricEnergy = buffer.readInt();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            lazyFluidsWithVolumetricEnergy.add((Lazy<Pair<ArrayList<Fluid>, Integer>>)Lazy.of(() -> new Pair((Object)((ArrayList)recipe.rawFluidInputList.get()), (Object)recipe.volumetricEnergy)));
            recipe.result = new ItemStack((ItemLike)Items.f_42446_);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, CombustionGeneratorFuelRecipe recipe) {
            buffer.writeBoolean(recipe.fluidUsesTagKey);
            if (recipe.fluidUsesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((Integer)recipe.inputArraySize.get()).intValue());
                for (int i = 0; i < (Integer)recipe.inputArraySize.get(); ++i) {
                    buffer.writeFluidStack(((FluidStack)((ArrayList)recipe.fluidInputList.get()).get(i)).copy());
                }
            }
            buffer.writeInt(recipe.ingredientCount);
            buffer.writeInt(recipe.volumetricEnergy);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

