/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CentrifugalAgitatorRecipe
extends VEFluidRecipe {
    public static final RecipeType<VEFluidRecipe> RECIPE_TYPE = (RecipeType)VERecipes.VERecipeTypes.CENTRIFUGAL_AGITATING.get();
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int processTime;
    private FluidStack result;
    private FluidStack secondResult;
    private int inputAmount;
    private int outputAmount;
    private int secondAmount;

    @Override
    public ArrayList<Item> getIngredientList() {
        return null;
    }

    public CentrifugalAgitatorRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    @Override
    public Ingredient getIngredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int getIngredientCount() {
        return this.ingredientCount;
    }

    @Override
    @Deprecated
    public ItemStack getResult() {
        return new ItemStack((ItemLike)this.result.getFluid().m_6859_());
    }

    public FluidStack getSecondResult() {
        return this.secondResult;
    }

    @Override
    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> f = new ArrayList<FluidStack>();
        f.add(this.getOutputFluid());
        f.add(this.getSecondFluid());
        return f;
    }

    @Override
    public List<Fluid> getRawFluids() {
        ArrayList<Fluid> f = new ArrayList<Fluid>();
        f.add(this.getOutputFluid().getRawFluid());
        f.add(this.getSecondFluid().getRawFluid());
        return f;
    }

    @Override
    public List<ItemStack> getResults() {
        return null;
    }

    public FluidStack getSecondFluid() {
        return this.secondResult.copy();
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.result.copy();
    }

    @Override
    public List<Integer> getAmounts() {
        return null;
    }

    @Deprecated
    public FluidStack getInputFluid() {
        return ((FluidStack)((ArrayList)this.fluidInputList.get()).get(0)).copy();
    }

    @Override
    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stack = inv.m_8020_(0);
        int count = stack.m_41613_();
        return ((Ingredient)this.ingredient.get()).test(stack) && count >= this.ingredientCount;
    }

    @Override
    public ItemStack assemble(Container inv) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    @Deprecated
    public ItemStack getResultItem() {
        return this.getResult();
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public RecipeType<VEFluidRecipe> m_6671_() {
        return RECIPE_TYPE;
    }

    @Override
    public int getOutputAmount() {
        return this.outputAmount;
    }

    @Override
    public int getInputAmount() {
        return this.inputAmount;
    }

    public int getSecondAmount() {
        return this.secondAmount;
    }

    @Override
    public int getProcessTime() {
        return this.processTime;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)VEBlocks.CENTRIFUGAL_AGITATOR_BLOCK.get());
    }

    public static class Serializer
    implements RecipeSerializer<CentrifugalAgitatorRecipe> {
        public CentrifugalAgitatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            CentrifugalAgitatorRecipe recipe = new CentrifugalAgitatorRecipe(recipeId);
            JsonObject ingredientJson = json.get("ingredient").getAsJsonObject();
            recipe.ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)ingredientJson));
            recipe.ingredientCount = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
            recipe.processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            JsonObject inputFluid = json.get("input_fluid").getAsJsonObject();
            recipe.inputAmount = GsonHelper.m_13824_((JsonObject)inputFluid, (String)"amount", (int)0);
            if (inputFluid.has("tag") && !inputFluid.has("fluid")) {
                ResourceLocation fluidTagLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"tag", (String)"minecraft:air"), (char)':');
                RecipeUtil.setupFluidLazyArrayInputsUsingTags(recipe, fluidTagLocation, recipe.inputAmount);
            } else if (inputFluid.has("fluid") && !inputFluid.has("tag")) {
                ResourceLocation fluidResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)inputFluid, (String)"fluid", (String)"minecraft:empty"), (char)':');
                RecipeUtil.setupFluidLazyArrayInputsWithFluid(recipe, fluidResourceLocation, recipe.inputAmount);
            } else {
                throw new JsonSyntaxException("Bad syntax for the Centrifugal Agitator recipe, input_fluid must be tag or fluid");
            }
            ResourceLocation bucketResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("first_result").getAsJsonObject(), (String)"fluid", (String)"minecraft:empty"), (char)':');
            int firstOutputFluidAmount = GsonHelper.m_13824_((JsonObject)json.get("first_result").getAsJsonObject(), (String)"amount", (int)0);
            recipe.result = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(bucketResourceLocation)), firstOutputFluidAmount);
            recipe.outputAmount = firstOutputFluidAmount;
            ResourceLocation secondBucketResourceLocation = ResourceLocation.m_135822_((String)GsonHelper.m_13851_((JsonObject)json.get("second_result").getAsJsonObject(), (String)"fluid", (String)"minecraft:empty"), (char)':');
            int secondOutputFluidAmount = GsonHelper.m_13824_((JsonObject)json.get("second_result").getAsJsonObject(), (String)"amount", (int)0);
            recipe.secondResult = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(secondBucketResourceLocation)), secondOutputFluidAmount);
            recipe.secondAmount = secondOutputFluidAmount;
            return recipe;
        }

        @Nullable
        public CentrifugalAgitatorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CentrifugalAgitatorRecipe recipe = new CentrifugalAgitatorRecipe(recipeId);
            recipe.ingredientCount = buffer.readByte();
            recipe.inputAmount = buffer.readInt();
            recipe.fluidUsesTagKey = buffer.readBoolean();
            if (recipe.fluidUsesTagKey) {
                ResourceLocation fluidTagLocation = buffer.m_130281_();
                recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
                recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, recipe.inputAmount);
                recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
            } else {
                int inputArraySize = buffer.readInt();
                recipe.inputArraySize = Lazy.of(() -> inputArraySize);
                ArrayList<Fluid> fluids = new ArrayList<Fluid>();
                ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
                for (int i = 0; i < inputArraySize; ++i) {
                    FluidStack serverFluid = buffer.readFluidStack();
                    fluidStacks.add(serverFluid.copy());
                    fluids.add(serverFluid.getRawFluid());
                }
                recipe.fluidInputList = Lazy.of(() -> fluidStacks);
                recipe.rawFluidInputList = Lazy.of(() -> fluids);
            }
            recipe.result = buffer.readFluidStack();
            recipe.processTime = buffer.readInt();
            recipe.outputAmount = buffer.readInt();
            recipe.secondResult = buffer.readFluidStack();
            recipe.secondAmount = buffer.readInt();
            Ingredient tempIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.ingredient = Lazy.of(() -> tempIngredient);
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, CentrifugalAgitatorRecipe recipe) {
            buffer.writeByte(recipe.getIngredientCount());
            buffer.writeInt(recipe.inputAmount);
            buffer.writeBoolean(recipe.fluidUsesTagKey);
            if (recipe.fluidUsesTagKey) {
                buffer.m_130085_(new ResourceLocation(recipe.tagKeyString));
            } else {
                buffer.writeInt(((Integer)recipe.inputArraySize.get()).intValue());
                for (int i = 0; i < (Integer)recipe.inputArraySize.get(); ++i) {
                    buffer.writeFluidStack(((FluidStack)((ArrayList)recipe.fluidInputList.get()).get(i)).copy());
                }
            }
            buffer.writeFluidStack(recipe.result);
            buffer.writeInt(recipe.processTime);
            buffer.writeInt(recipe.outputAmount);
            buffer.writeFluidStack(recipe.secondResult);
            buffer.writeInt(recipe.secondAmount);
            ((Ingredient)recipe.ingredient.get()).m_43923_(buffer);
        }
    }
}

