/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.persistence;

import com.veteam.voluminousenergy.persistence.ChunkFluid;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ChunkFluids
extends SavedData {
    private static ChunkFluids CHUNK_FLUIDS;
    private final Set<ChunkFluid> chunkFluidSet = new HashSet<ChunkFluid>();
    private final ServerLevel level;
    private int nextAvailableID;
    private int tick;

    public ChunkFluids(ServerLevel serverLevel) {
        this.level = serverLevel;
        this.nextAvailableID = 1;
        this.m_77762_();
    }

    public void tick() {
        ++this.tick;
        Iterator<ChunkFluid> iterator = this.chunkFluidSet.iterator();
        if (this.tick % 20 == 0) {
            this.m_77762_();
        }
    }

    public static ChunkFluids load(ServerLevel serverLevel, CompoundTag compoundTag) {
        ChunkFluids chunkFluid = new ChunkFluids(serverLevel);
        chunkFluid.nextAvailableID = compoundTag.m_128451_("NextAvailableID");
        chunkFluid.tick = compoundTag.m_128451_("Tick");
        ListTag listtag = compoundTag.m_128437_("ChunkFluids", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ChunkFluid cf = new ChunkFluid(compoundtag);
            chunkFluid.chunkFluidSet.add(cf);
        }
        return chunkFluid;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag p_37976_) {
        p_37976_.m_128405_("NextAvailableID", this.nextAvailableID);
        p_37976_.m_128405_("Tick", this.tick);
        ListTag listtag = new ListTag();
        for (ChunkFluid chunkFluid : this.chunkFluidSet.stream().toList()) {
            CompoundTag compoundtag = new CompoundTag();
            chunkFluid.save(compoundtag);
            listtag.add((Object)compoundtag);
        }
        p_37976_.m_128365_("ChunkFluids", (Tag)listtag);
        return p_37976_;
    }

    public static String getFileId(Holder<DimensionType> dimensionTypeHolder) {
        return "chunk_fluids";
    }

    private int getUniqueId() {
        return ++this.nextAvailableID;
    }

    @Nullable
    public ChunkFluid getChunkFluid(ChunkPos chunkPos) {
        for (ChunkFluid chunkFluid : this.chunkFluidSet.stream().toList()) {
            if (!chunkFluid.getChunkPos().equals((Object)chunkPos)) continue;
            return chunkFluid;
        }
        return null;
    }

    public boolean hasChunkFluid(ChunkFluid cf) {
        for (ChunkFluid chunkFluid : this.chunkFluidSet.stream().toList()) {
            if (!chunkFluid.getChunkPos().equals((Object)cf.getChunkPos())) continue;
            return true;
        }
        return false;
    }

    public static void loadInstance(ServerLevel serverLevel) {
        if (CHUNK_FLUIDS == null) {
            CHUNK_FLUIDS = (ChunkFluids)serverLevel.m_8895_().m_164861_(compoundTag -> ChunkFluids.load(serverLevel, compoundTag), () -> new ChunkFluids(serverLevel), ChunkFluids.getFileId((Holder<DimensionType>)serverLevel.m_204156_()));
        }
    }

    public static ChunkFluids getInstance() {
        return CHUNK_FLUIDS;
    }

    public void add(ChunkFluid chunkFluid) {
        this.chunkFluidSet.add(chunkFluid);
    }

    public ChunkFluid getOrElse(ChunkFluid fluid) {
        return this.chunkFluidSet.stream().filter(chunkFluid -> chunkFluid.getChunkPos().equals((Object)fluid.getChunkPos())).findFirst().orElse(fluid);
    }
}

