/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.persistence;

import com.veteam.voluminousenergy.persistence.SingleChunkFluid;
import com.veteam.voluminousenergy.util.RegistryLookups;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import oshi.util.tuples.Pair;

public class ChunkFluid {
    private final ChunkPos chunkPos;
    private final List<SingleChunkFluid> chunkFluidList = new ArrayList<SingleChunkFluid>();

    public ChunkFluid(CompoundTag compoundTag) {
        this.chunkPos = new ChunkPos(compoundTag.m_128451_("CX"), compoundTag.m_128451_("CZ"));
        int i = 0;
        while (compoundTag.m_128441_("SCF_" + i)) {
            SingleChunkFluid singleChunkFluid = new SingleChunkFluid((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(compoundTag.m_128461_("SCF_" + i))), compoundTag.m_128451_("FS_" + i));
            this.chunkFluidList.add(singleChunkFluid);
            ++i;
        }
    }

    public ChunkFluid(ChunkPos chunkPos, ArrayList<Pair<Fluid, Integer>> fluidPairs) {
        this.chunkPos = chunkPos;
        for (Pair<Fluid, Integer> value : fluidPairs) {
            this.chunkFluidList.add(new SingleChunkFluid((Fluid)value.getA(), (Integer)value.getB()));
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128405_("CX", this.chunkPos.f_45578_);
        compoundTag.m_128405_("CZ", this.chunkPos.f_45579_);
        for (int i = 0; i < this.chunkFluidList.size(); ++i) {
            SingleChunkFluid fluid = this.chunkFluidList.get(i);
            compoundTag.m_128405_("FS_" + i, fluid.getAmount());
            compoundTag.m_128359_("SCF_" + i, RegistryLookups.lookupFluid(fluid.getFluid()).toString());
        }
        return compoundTag;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public List<SingleChunkFluid> getFluids() {
        return this.chunkFluidList;
    }
}

