/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.loot.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.veteam.voluminousenergy.items.VEItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class MysteriousMultiplierModifier
extends LootModifier {
    public static final Supplier<Codec<MysteriousMultiplierModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(MysteriousMultiplierModifier::getLootItemConditions)).apply((Applicative)instance, MysteriousMultiplierModifier::new)));

    public MysteriousMultiplierModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        AtomicBoolean generatedMysteriousMultiplier = new AtomicBoolean(false);
        generatedLoot.parallelStream().forEach(generatedItemStack -> {
            if (generatedItemStack.m_150930_((Item)VEItems.MYSTERIOUS_MULTIPLIER.get())) {
                generatedMysteriousMultiplier.set(true);
            }
        });
        if (!generatedMysteriousMultiplier.get()) {
            ObjectArrayList clonedArray = generatedLoot.clone();
            clonedArray.add((Object)new ItemStack((ItemLike)VEItems.MYSTERIOUS_MULTIPLIER.get(), 1));
            return clonedArray;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public LootItemCondition[] getLootItemConditions() {
        return this.conditions;
    }
}

