/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.loot.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AnimalFatLootModifier
extends LootModifier {
    public static final Supplier<Codec<AnimalFatLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(animalFatLootModifierInstance -> animalFatLootModifierInstance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(AnimalFatLootModifier::getLootItemConditions), (App)ItemStack.f_41582_.fieldOf("addition").forGetter(AnimalFatLootModifier::getItemStackAddition), (App)Codec.INT.fieldOf("minimum_count").forGetter(AnimalFatLootModifier::getMinAmount), (App)Codec.INT.fieldOf("maximum_count").forGetter(AnimalFatLootModifier::getMaxAmount)).apply((Applicative)animalFatLootModifierInstance, AnimalFatLootModifier::new)));
    private final ItemStack itemAddition;
    private final int minAmount;
    private final int maxAmount;

    public AnimalFatLootModifier(LootItemCondition[] conditionsIn, ItemStack itemStack, int minAmount, int maxAmount) {
        super(conditionsIn);
        this.itemAddition = itemStack;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    public AnimalFatLootModifier(LootItemCondition[] conditionsIn, Item item, int minAmount, int maxAmount) {
        super(conditionsIn);
        this.itemAddition = new ItemStack((ItemLike)item, 1);
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    @NotNull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        float luck = context.m_78945_() > 0.0f ? context.m_78945_() : 1.0f;
        float lootingModif = context.getLootingModifier() > 0 ? (float)context.getLootingModifier() : 1.0f;
        RandomSource contextualizedRandom = context.m_230907_();
        int amount = contextualizedRandom.m_216339_(this.minAmount, this.maxAmount);
        amount = Math.round((float)amount * luck);
        amount = Math.round((float)amount * lootingModif);
        ItemStack stackToAdd = this.itemAddition.m_41777_();
        stackToAdd.m_41764_(amount);
        generatedLoot.add((Object)stackToAdd);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public ItemStack getItemStackAddition() {
        return this.itemAddition;
    }

    public LootItemCondition[] getLootItemConditions() {
        return this.conditions;
    }
}

