/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.items.upgrades;

import com.veteam.voluminousenergy.util.TextUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MysteriousMultiplier
extends Item {
    public static final List<QualityTier> QUALITY_TIERS = List.of(QualityTier.BASIC, QualityTier.GRAND, QualityTier.RARE, QualityTier.ARCANE, QualityTier.HEROIC, QualityTier.UNIQUE, QualityTier.CELESTIAL, QualityTier.DIVINE, QualityTier.EPIC, QualityTier.LEGENDARY, QualityTier.MYTHIC);
    public static final HashMap<QualityTier, Float> REFERENCE_MULTIPLIER_VALUES = new HashMap<QualityTier, Float>(){
        {
            this.put(QualityTier.BASIC, Float.valueOf(0.66f));
            this.put(QualityTier.GRAND, Float.valueOf(0.55f));
            this.put(QualityTier.RARE, Float.valueOf(0.45f));
            this.put(QualityTier.ARCANE, Float.valueOf(0.35f));
            this.put(QualityTier.HEROIC, Float.valueOf(0.27f));
            this.put(QualityTier.UNIQUE, Float.valueOf(0.21f));
            this.put(QualityTier.CELESTIAL, Float.valueOf(0.15f));
            this.put(QualityTier.DIVINE, Float.valueOf(0.08f));
            this.put(QualityTier.EPIC, Float.valueOf(0.06f));
            this.put(QualityTier.LEGENDARY, Float.valueOf(0.03f));
            this.put(QualityTier.MYTHIC, Float.valueOf(0.005f));
        }
    };

    public MysteriousMultiplier() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        float multiplier;
        MutableComponent componentToAdd = TextUtil.translateString("text.voluminousenergy.quality").m_6881_().m_130946_(": ");
        componentToAdd = stack.m_41783_() == null ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.unidentified")).m_130940_(ChatFormatting.BOLD) : ((multiplier = stack.m_41783_().m_128457_("multiplier")) >= 0.65f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.basic")).m_130940_(ChatFormatting.WHITE) : (multiplier >= 0.5f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.grand")).m_130940_(ChatFormatting.GREEN) : (multiplier >= 0.4f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.rare")).m_130940_(ChatFormatting.BLUE) : (multiplier >= 0.3f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.arcane")).m_130940_(ChatFormatting.LIGHT_PURPLE) : (multiplier >= 0.25f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.heroic")).m_130940_(ChatFormatting.YELLOW) : (multiplier >= 0.2f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.unique")).m_130948_(Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(16542467)) : (multiplier >= 0.1f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.celestial")).m_130940_(ChatFormatting.RED) : (multiplier >= 0.075f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.divine")).m_130948_(Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(13598045).m_131136_(Boolean.valueOf(true))) : (multiplier >= 0.05f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.epic")).m_130948_(Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(9414090).m_131136_(Boolean.valueOf(true))) : (multiplier >= 0.025f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.legendary")).m_130948_(Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(12548352).m_131136_(Boolean.valueOf(true))) : (multiplier <= 0.025f ? componentToAdd.m_6881_().m_7220_(TextUtil.translateString("text.voluminousenergy.quality.mythic")).m_130948_(Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(13175563).m_131136_(Boolean.valueOf(true))) : componentToAdd.m_6881_().m_130946_("DEBUGWARN: NoneOfTheAbove: " + multiplier))))))))))));
        tooltip.add((Component)componentToAdd);
        tooltip.add(this.appendInfoForJEI(Component.m_130674_((String)""), stack));
    }

    public Component appendInfoForJEI(Component tooltip, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("jei") && stack.m_41783_().m_128441_("multiplier")) {
            QualityTier tier = MysteriousMultiplier.getQualityTier(stack.m_41783_().m_128457_("multiplier"));
            tooltip = switch (tier) {
                default -> throw new IncompatibleClassChangeError();
                case QualityTier.NULL -> tooltip.m_6881_();
                case QualityTier.BASIC -> tooltip.m_6881_().m_130946_("1x ~ 0.65x");
                case QualityTier.GRAND -> tooltip.m_6881_().m_130946_("0.65x ~ 0.5x");
                case QualityTier.RARE -> tooltip.m_6881_().m_130946_("0.5x ~ 0.4x");
                case QualityTier.ARCANE -> tooltip.m_6881_().m_130946_("0.4x ~ 0.3x");
                case QualityTier.HEROIC -> tooltip.m_6881_().m_130946_("0.3x ~ 0.25x");
                case QualityTier.UNIQUE -> tooltip.m_6881_().m_130946_("0.25x ~ 0.2x");
                case QualityTier.CELESTIAL -> tooltip.m_6881_().m_130946_("0.2x ~ 0.1x");
                case QualityTier.DIVINE -> tooltip.m_6881_().m_130946_("0.1x ~ 0.075x");
                case QualityTier.EPIC -> tooltip.m_6881_().m_130946_("0.075x ~ 0.05x");
                case QualityTier.LEGENDARY -> tooltip.m_6881_().m_130946_("0.05x ~ 0.025x");
                case QualityTier.MYTHIC -> tooltip.m_6881_().m_130946_("<0.025x");
            };
        }
        return tooltip;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int num, boolean bool) {
        if (!(stack.m_41783_() == null && !level.m_5776_() || !level.m_5776_() && stack.m_41783_().m_128456_())) {
            return;
        }
        float multiplier = level.m_213780_().m_188501_() * 0.745f + 0.005f;
        stack.m_41784_().m_128350_("multiplier", multiplier);
    }

    public static QualityTier getQualityTier(float multiplier) {
        if (multiplier >= 0.65f) {
            return QualityTier.BASIC;
        }
        if (multiplier >= 0.5f) {
            return QualityTier.GRAND;
        }
        if (multiplier >= 0.4f) {
            return QualityTier.RARE;
        }
        if (multiplier >= 0.3f) {
            return QualityTier.ARCANE;
        }
        if (multiplier >= 0.25f) {
            return QualityTier.HEROIC;
        }
        if (multiplier >= 0.2f) {
            return QualityTier.UNIQUE;
        }
        if (multiplier >= 0.1f) {
            return QualityTier.CELESTIAL;
        }
        if (multiplier >= 0.075f) {
            return QualityTier.DIVINE;
        }
        if (multiplier >= 0.05f) {
            return QualityTier.EPIC;
        }
        if (multiplier >= 0.025f) {
            return QualityTier.LEGENDARY;
        }
        if (multiplier <= 0.025f) {
            return QualityTier.MYTHIC;
        }
        return QualityTier.NULL;
    }

    public static enum QualityTier {
        NULL,
        BASIC,
        GRAND,
        RARE,
        ARCANE,
        HEROIC,
        UNIQUE,
        CELESTIAL,
        DIVINE,
        EPIC,
        LEGENDARY,
        MYTHIC;

    }
}

