/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.items.tools.multitool;

import com.veteam.voluminousenergy.items.tools.multitool.Multitool;
import com.veteam.voluminousenergy.items.tools.multitool.bits.MultitoolBit;
import com.veteam.voluminousenergy.util.NumberUtil;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class CombustionMultitool
extends Multitool {
    public final int TANK_CAPACITY = 4000;

    public CombustionMultitool(MultitoolBit bit, String registryName, Item.Properties itemProperties) {
        super(bit, registryName, itemProperties);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (ForgeCapabilities.FLUID_HANDLER_ITEM == null) {
            return;
        }
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
            FluidStack fluidStack = fluid.getFluidInTank(0).copy();
            tooltip.add((Component)TextUtil.translateString(fluidStack.getTranslationKey()).m_6881_().m_130946_(": " + NumberUtil.formatNumber(fluidStack.getAmount()) + " mB / " + NumberUtil.formatNumber(this.TANK_CAPACITY) + " mB"));
            if (itemStack.m_41783_() != null) {
                tooltip.add((Component)TextUtil.translateString("text.voluminousenergy.energy").m_6881_().m_130946_(": " + NumberUtil.formatNumber(itemStack.m_41783_().m_128451_("energy"))));
            }
        });
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        AtomicInteger fluidInTank = new AtomicInteger(0);
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
            FluidStack fluidStack = fluid.getFluidInTank(0).copy();
            fluidInTank.set(fluidStack.getAmount());
        });
        return (int)Math.round(13.0 * ((double)fluidInTank.get() / (double)this.TANK_CAPACITY));
    }

    public int m_142159_(ItemStack itemStack) {
        AtomicReference<Float> ratio = new AtomicReference<Float>(Float.valueOf(0.0f));
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
            float f = fluid.getFluidInTank(0).getAmount();
            Objects.requireNonNull(this);
            ratio.set(Float.valueOf(f / 4000.0f));
        });
        return Mth.m_14169_((float)(ratio.get().floatValue() / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(itemStack, this.TANK_CAPACITY);
    }

    public void setDamage(ItemStack stack, int damage) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        int usesLeftUntilRefuel = tag.m_128451_("energy");
        if (usesLeftUntilRefuel < 1) {
            AtomicInteger volumetricEnergy = new AtomicInteger(0);
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
                FluidStack itemFluid = fluid.getFluidInTank(0).copy();
                if (!itemFluid.isEmpty() && RecipeUtil.isCombustibleFuelWithoutLevel(itemFluid.getRawFluid()) && fluid.getFluidInTank(0).getAmount() > 50) {
                    fluid.drain(50, IFluidHandler.FluidAction.EXECUTE);
                    volumetricEnergy.set(RecipeUtil.getVolumetricEnergyWithoutLevel(fluid.getFluidInTank(0).getRawFluid()) / 50);
                }
            });
            stack.m_41784_().m_128405_("energy", volumetricEnergy.get());
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            AtomicInteger volumetricEnergy = new AtomicInteger();
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
                FluidStack itemFluid = fluid.getFluidInTank(0).copy();
                if (RecipeUtil.isCombustibleFuelWithoutLevel(itemFluid.getRawFluid()) && fluid.getFluidInTank(0).getAmount() > 50) {
                    fluid.drain(50, IFluidHandler.FluidAction.EXECUTE);
                    volumetricEnergy.set(RecipeUtil.getVolumetricEnergyWithoutLevel(fluid.getFluidInTank(0).getRawFluid()) / 50);
                    stack.m_41784_().m_128405_("damage", volumetricEnergy.get());
                }
            });
            return -volumetricEnergy.get() > 0 ? -volumetricEnergy.get() : -1;
        }
        if (tag == null) {
            return 0;
        }
        int usesLeftUntilRefuel = tag.m_128451_("energy");
        if (usesLeftUntilRefuel > 1) {
            stack.m_41783_().m_128405_("energy", usesLeftUntilRefuel - amount);
            return -1;
        }
        if (usesLeftUntilRefuel <= 1) {
            AtomicInteger volumetricEnergy = new AtomicInteger(0);
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
                FluidStack itemFluid = fluid.getFluidInTank(0).copy();
                if (RecipeUtil.isCombustibleFuelWithoutLevel(itemFluid.getRawFluid()) && fluid.getFluidInTank(0).getAmount() >= 50) {
                    fluid.drain(50, IFluidHandler.FluidAction.EXECUTE);
                    volumetricEnergy.set(RecipeUtil.getVolumetricEnergyWithoutLevel(fluid.getFluidInTank(0).getRawFluid()) / 50);
                }
            });
            stack.m_41784_().m_128405_("energy", volumetricEnergy.get());
            return -volumetricEnergy.get() > 0 ? -volumetricEnergy.get() : -1;
        }
        return -1;
    }

    public boolean isDamageable(ItemStack itemStack) {
        return true;
    }

    public void m_142023_(ItemEntity itemEntity) {
        this.onDestroyed(itemEntity.m_32055_());
    }

    public void onDestroyed(ItemStack itemStack) {
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
            FluidStack itemFluid = fluid.getFluidInTank(0).copy();
            if (RecipeUtil.isCombustibleFuelWithoutLevel(itemFluid.getRawFluid()) && fluid.getFluidInTank(0).getAmount() > 50) {
                fluid.drain(50, IFluidHandler.FluidAction.EXECUTE);
                int volumetricEnergy = RecipeUtil.getVolumetricEnergyWithoutLevel(fluid.getFluidInTank(0).getRawFluid());
                itemFluid.getOrCreateTag().m_128405_("energy", volumetricEnergy);
            }
        });
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    @Override
    public float m_8102_(ItemStack itemStack, BlockState blockStateToMine) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            if (tag.m_128451_("energy") > 1) {
                return super.m_8102_(itemStack, blockStateToMine);
            }
            AtomicBoolean notEmpty = new AtomicBoolean(false);
            itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> notEmpty.set(!fluid.getFluidInTank(0).isEmpty()));
            if (notEmpty.get()) {
                return super.m_8102_(itemStack, blockStateToMine);
            }
        }
        return 0.0f;
    }
}

