/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.items.tools;

import com.veteam.voluminousenergy.items.VEItems;
import com.veteam.voluminousenergy.items.tools.RFIDChip;
import com.veteam.voluminousenergy.persistence.ChunkFluid;
import com.veteam.voluminousenergy.persistence.ChunkFluids;
import com.veteam.voluminousenergy.persistence.SingleChunkFluid;
import com.veteam.voluminousenergy.util.TextUtil;
import com.veteam.voluminousenergy.util.WorldUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidScanner
extends Item {
    public FluidScanner() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public int m_8105_(ItemStack p_40680_) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack p_40678_) {
        return UseAnim.CROSSBOW;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        BlockPos blockpos = useOnContext.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        ChunkAccess chunkAccess = level.m_46865_(blockpos);
        Player player = useOnContext.m_43723_();
        if (player == null || level.f_46443_) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockPos pos = new BlockPos(16 * chunkAccess.m_7697_().f_45578_, 320, 16 * chunkAccess.m_7697_().f_45579_);
        HashMap<WorldUtil.ClimateParameters, Double> climateMap = WorldUtil.sampleClimate(level, pos);
        StringBuilder climateString = new StringBuilder();
        climateString.append("\nC: " + climateMap.get((Object)WorldUtil.ClimateParameters.CONTINENTALNESS));
        climateString.append("\nE: " + climateMap.get((Object)WorldUtil.ClimateParameters.EROSION));
        climateString.append("\nH: " + climateMap.get((Object)WorldUtil.ClimateParameters.HUMIDITY));
        climateString.append("\nT: " + climateMap.get((Object)WorldUtil.ClimateParameters.TEMPERATURE));
        if (player.m_6144_()) {
            ChunkFluid chunkFluid = ChunkFluids.getInstance().getChunkFluid(chunkAccess.m_7697_());
            if (chunkFluid == null) {
                player.m_213846_(TextUtil.translateString(ChatFormatting.RED, "text.voluminousenergy.rfid.chunk_not_scanned"));
                return InteractionResult.m_19078_((boolean)false);
            }
            PlayerInvWrapper inventory = new PlayerInvWrapper(player.m_150109_());
            int freeSlot = player.m_150109_().m_36062_();
            if (freeSlot == -1) {
                player.m_213846_(TextUtil.translateString(ChatFormatting.RED, "text.voluminousenergy.rfid.inventory_full"));
            } else {
                for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                    ItemStack itemStack = inventory.getStackInSlot(slot);
                    if (!(itemStack.m_41720_() instanceof RFIDChip) || itemStack.m_41782_() || itemStack.m_41784_().m_128441_("ve_x")) continue;
                    if (!itemStack.m_41784_().m_128441_("ve_x")) {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        ItemStack dataStack = new ItemStack((ItemLike)VEItems.RFID_CHIP.get(), 1);
                        CompoundTag data = dataStack.m_41784_();
                        boolean x = false;
                        chunkFluid.save(data);
                        data.m_128405_("ve_x", chunkAccess.m_7697_().f_45578_);
                        data.m_128405_("ve_z", chunkAccess.m_7697_().f_45579_);
                        dataStack.m_41751_(data);
                        inventory.insertItem(freeSlot, dataStack, false);
                        player.m_213846_(TextUtil.translateString(ChatFormatting.GREEN, "text.voluminousenergy.rfid.write_success"));
                    }
                    return InteractionResult.m_19078_((boolean)false);
                }
            }
            player.m_213846_(TextUtil.translateString(ChatFormatting.RED, "text.voluminousenergy.fluid_scanner.needs_empty_rfid"));
            return InteractionResult.m_19078_((boolean)false);
        }
        player.m_213846_((Component)TextUtil.translateString(ChatFormatting.YELLOW, "text.voluminousenergy.fluid_scanner.scanning").m_6881_().m_7220_(Component.m_130674_((String)(ChatFormatting.YELLOW + "..."))));
        ChunkFluid fluid = WorldUtil.getFluidFromPosition(level, pos);
        StringBuilder builder = new StringBuilder();
        for (SingleChunkFluid singleChunkFluid : fluid.getFluids()) {
            builder.append(TextUtil.fluidNameAndAmountWithUnitsAndColours(singleChunkFluid).getString());
        }
        player.m_213846_(Component.m_130674_((String)builder.toString()));
        ItemStack hand = useOnContext.m_43722_();
        CompoundTag tag = hand.m_41784_();
        if (tag.m_128441_("ve_x")) {
            tag.m_128473_("ve_x");
            tag.m_128473_("ve_z");
        }
        tag.m_128405_("ve_x", chunkAccess.m_7697_().f_45578_);
        tag.m_128405_("ve_z", chunkAccess.m_7697_().f_45579_);
        fluid.save(tag);
        hand.m_41751_(tag);
        return InteractionResult.m_19078_((boolean)false);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> componentList, @NotNull TooltipFlag tooltipFlag) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_("ve_x")) {
            int x = tag.m_128451_("ve_x");
            int z = tag.m_128451_("ve_z");
            ChunkFluid fluid = new ChunkFluid(tag);
            fluid.getFluids().forEach(f -> componentList.add(TextUtil.fluidNameAndAmountWithUnitsAndColours(f)));
            componentList.add(Component.m_130674_((String)("Chunk X: " + x + " | Chunk Z: " + z)));
        }
        super.m_7373_(itemStack, level, componentList, tooltipFlag);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return true;
    }
}

