/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.items.tools;

import com.veteam.voluminousenergy.fluids.VEFluids;
import com.veteam.voluminousenergy.util.NumberUtil;
import com.veteam.voluminousenergy.util.RegistryLookups;
import com.veteam.voluminousenergy.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class CreativeFluidScanner
extends Item {
    public CreativeFluidScanner() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.CROSSBOW;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        BlockPos blockpos = useOnContext.m_8083_();
        ChunkAccess chunkAccess = level.m_46865_(blockpos);
        Player player = useOnContext.m_43723_();
        if (player == null || level.f_46443_) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockPos pos = new BlockPos(16 * chunkAccess.m_7697_().f_45578_, 320, 16 * chunkAccess.m_7697_().f_45579_);
        HashMap<WorldUtil.ClimateParameters, Double> climateMap = WorldUtil.sampleClimate(level, pos);
        StringBuilder climateString = new StringBuilder();
        climateString.append("\nC: " + climateMap.get((Object)WorldUtil.ClimateParameters.CONTINENTALNESS));
        climateString.append("\nE: " + climateMap.get((Object)WorldUtil.ClimateParameters.EROSION));
        climateString.append("\nH: " + climateMap.get((Object)WorldUtil.ClimateParameters.HUMIDITY));
        climateString.append("\nT: " + climateMap.get((Object)WorldUtil.ClimateParameters.TEMPERATURE));
        player.m_213846_(Component.m_130674_((String)"Scanning..."));
        player.m_213846_(Component.m_130674_((String)climateString.toString()));
        ArrayList<Pair<Fluid, Integer>> fluidsList = WorldUtil.queryForFluids(level, pos);
        StringBuilder message = new StringBuilder();
        Fluid fluid = Fluids.f_76191_;
        for (Pair<Fluid, Integer> pair : fluidsList) {
            message.append("\nFound Entry: ").append(RegistryLookups.lookupFluid((Fluid)pair.getA())).append(" Amount: ").append(NumberUtil.formatNumber(((Integer)pair.getB()).intValue())).append(" mB");
        }
        player.m_213846_(Component.m_130674_((String)message.toString()));
        StringBuilder builder = new StringBuilder("______________MAP______________\n");
        int mapSize = 16;
        int middle = mapSize / 2;
        for (int x = 1; x < mapSize; ++x) {
            for (int z = 1; z < mapSize; ++z) {
                pos = new BlockPos(16 * (chunkAccess.m_7697_().f_45578_ - middle + x), 320, 16 * (chunkAccess.m_7697_().f_45579_ - middle + z));
                ArrayList<Pair<Fluid, Integer>> items = WorldUtil.queryForFluids(level, pos);
                if (items.size() > 0) {
                    fluid = (Fluid)items.get(0).getA();
                    if (fluid.m_6212_(((FlowingFluid)VEFluids.CRUDE_OIL_REG.get()).m_5615_())) {
                        builder.append(" C |");
                        continue;
                    }
                    if (fluid.m_6212_(Fluids.f_76193_.m_5615_())) {
                        builder.append(" W |");
                        continue;
                    }
                    if (fluid.m_6212_(Fluids.f_76195_.m_5615_())) {
                        builder.append(" L |");
                        continue;
                    }
                    if (fluid.m_6212_(((FlowingFluid)VEFluids.LIGHT_FUEL_REG.get()).m_5615_())) {
                        builder.append(" F |");
                        continue;
                    }
                    builder.append(" ? |");
                    continue;
                }
                builder.append(" 0 |");
            }
            builder.append("\n");
        }
        player.m_213846_(Component.m_130674_((String)builder.toString()));
        return InteractionResult.m_19078_((boolean)false);
    }
}

