/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.items.batteries;

import com.veteam.voluminousenergy.items.VEItem;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.energy.VEEnergyItemStorage;
import com.veteam.voluminousenergy.util.NumberUtil;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class VEEnergyItem
extends VEItem {
    private final int maxEnergy;
    private final int maxTransfer;

    @Deprecated
    public VEEnergyItem(Item.Properties properties, int maxEnergy, int maxTransfer) {
        super(properties);
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
    }

    public static float getChargeRatio(ItemStack stack) {
        LazyOptional energy = stack.getCapability(ForgeCapabilities.ENERGY);
        if (energy.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)energy.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack itemStack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ENERGY) {
                    return LazyOptional.of(() -> new VEEnergyItemStorage(itemStack, VEEnergyItem.this.maxEnergy, VEEnergyItem.this.maxTransfer)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (ForgeCapabilities.ENERGY == null) {
            return;
        }
        itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> {
            MutableComponent textComponent = (Boolean)Config.SHORTEN_ITEM_TOOLTIP_VALUES.get() != false ? TextUtil.translateString("text.voluminousenergy.energy").m_6881_().m_130946_(": " + NumberUtil.numberToString4FE(e.getEnergyStored()) + " / " + NumberUtil.numberToString4FE(e.getMaxEnergyStored())) : TextUtil.translateString("text.voluminousenergy.energy").m_6881_().m_130946_(": " + NumberUtil.formatNumber(e.getEnergyStored()) + " FE / " + NumberUtil.formatNumber(e.getMaxEnergyStored()) + " FE");
            tooltip.add((Component)textComponent);
        });
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        return Math.round(13.0f * VEEnergyItem.getChargeRatio(itemStack));
    }

    public int m_142159_(ItemStack itemStack) {
        float f = VEEnergyItem.getChargeRatio(itemStack);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }
}

