/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.fluids;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class VEFluidType
extends FluidType {
    private final ResourceLocation STILL_TEXTURE;
    private final ResourceLocation FLOWING_TEXTURE;
    private ResourceLocation overlayTexture;
    private int colourTint;

    public VEFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(properties);
        this.STILL_TEXTURE = stillTexture;
        this.FLOWING_TEXTURE = flowingTexture;
    }

    public VEFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlayTexture) {
        super(properties);
        this.STILL_TEXTURE = stillTexture;
        this.FLOWING_TEXTURE = flowingTexture;
        this.overlayTexture = overlayTexture;
    }

    public void setColourTint(int colourTint) {
        this.colourTint = colourTint;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return VEFluidType.this.STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return VEFluidType.this.FLOWING_TEXTURE;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return VEFluidType.this.overlayTexture;
            }

            public int getTintColor() {
                return VEFluidType.this.colourTint > 0 ? VEFluidType.this.colourTint : super.getTintColor();
            }
        });
    }
}

