/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.fluids;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class VEFlowingGasFluid
extends ForgeFlowingFluid {
    private final int flowWidth;
    public static final BooleanProperty FALLING = BlockStateProperties.f_61434_;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61420_;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(200){

            protected void rehash(int p_76102_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    protected VEFlowingGasFluid(ForgeFlowingFluid.Properties properties, int blocksToFlowOutWide) {
        super(properties);
        this.flowWidth = blocksToFlowOutWide;
    }

    public void m_6292_(Level level, BlockPos blockPos, FluidState fluidState) {
        if (!fluidState.m_76170_()) {
            FluidState fluidstate = this.m_76035_(level, blockPos, level.m_8055_(blockPos));
            int i = this.m_6886_(level, blockPos, fluidState, fluidstate);
            if (fluidstate.m_76178_()) {
                fluidState = fluidstate;
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            } else if (!fluidstate.equals(fluidState)) {
                fluidState = fluidstate;
                BlockState blockstate = fluidstate.m_76188_();
                level.m_7731_(blockPos, blockstate, 2);
                level.m_186469_(blockPos, fluidstate.m_76152_(), i);
                level.m_46672_(blockPos, blockstate.m_60734_());
            }
        }
        this.m_76010_(level, blockPos, fluidState);
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> stateDefinitionBuilder) {
        super.m_7180_(stateDefinitionBuilder);
        stateDefinitionBuilder.m_61104_(new Property[]{LEVEL});
    }

    public Vec3 m_7000_(BlockGetter getter, BlockPos pos, FluidState fluidState) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
            FluidState fluidstate = getter.m_6425_((BlockPos)blockpos$mutableblockpos);
            if (!this.affectsFlow(fluidstate)) continue;
            float f = fluidstate.m_76182_();
            float f1 = 0.0f;
            if (f == 0.0f) {
                BlockPos blockpos;
                FluidState fluidstate1;
                if (!getter.m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_() && this.affectsFlow(fluidstate1 = getter.m_6425_(blockpos = blockpos$mutableblockpos.m_7494_())) && (f = fluidstate1.m_76182_()) > 0.0f) {
                    f1 = fluidState.m_76182_() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = fluidState.m_76182_() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)direction.m_122429_() * f1);
            d1 += (double)((float)direction.m_122431_() * f1);
        }
        Vec3 vec3 = new Vec3(d0, 0.0, d1);
        if (((Boolean)fluidState.m_61143_((Property)FALLING)).booleanValue()) {
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction1);
                if (!this.m_75990_(getter, (BlockPos)blockpos$mutableblockpos, direction1) && !this.m_75990_(getter, blockpos$mutableblockpos.m_7494_(), direction1)) continue;
                vec3 = vec3.m_82541_().m_82492_(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.m_82541_();
    }

    private boolean affectsFlow(FluidState fluidState) {
        return fluidState.m_76178_() || fluidState.m_76152_().m_6212_((Fluid)this);
    }

    protected void m_76010_(Level level, BlockPos blockPos, FluidState fluidState) {
        if (!fluidState.m_76178_()) {
            if (blockPos.m_123342_() >= 320) {
                return;
            }
            if (!fluidState.m_76170_()) {
                BlockState belowState = level.m_8055_(blockPos.m_7495_());
                FluidState belowFluidState = level.m_6425_(blockPos.m_7495_());
                if (!belowFluidState.m_76170_() && !belowFluidState.m_192917_((Fluid)this)) {
                    boolean foundSource = false;
                    FluidState fluidStateNorth = level.m_6425_(blockPos.m_122012_());
                    FluidState fluidStateSouth = level.m_6425_(blockPos.m_122019_());
                    FluidState fluidStateEast = level.m_6425_(blockPos.m_122029_());
                    FluidState fluidStateWest = level.m_6425_(blockPos.m_122024_());
                    if (fluidStateNorth.m_192917_((Fluid)this) && fluidStateNorth.m_76170_()) {
                        return;
                    }
                    if (fluidStateSouth.m_192917_((Fluid)this) && fluidStateSouth.m_76170_()) {
                        return;
                    }
                    if (fluidStateEast.m_192917_((Fluid)this) && fluidStateEast.m_76170_()) {
                        return;
                    }
                    if (fluidStateWest.m_192917_((Fluid)this) && fluidStateWest.m_76170_()) {
                        return;
                    }
                    block0: for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (foundSource) break;
                        for (int i = 1; i <= this.flowWidth; ++i) {
                            BlockPos dirPos = blockPos.m_5484_(direction, i);
                            FluidState foundFluidState = level.m_6425_(dirPos = dirPos.m_7495_());
                            if (!foundFluidState.m_76178_() && foundFluidState.m_192917_((Fluid)this)) {
                                foundSource = true;
                                continue block0;
                            }
                            if (belowState.m_60734_() instanceof BucketPickup || belowState.m_60734_() instanceof LiquidBlock || belowState.m_60795_() || belowState.m_60819_() == this.m_76145_()) continue;
                            BlockPos xPlusOne = blockPos.m_7918_(1, 0, 0);
                            BlockPos xMinusOne = blockPos.m_7918_(-1, 0, 0);
                            BlockPos zPlusOne = blockPos.m_7918_(0, 0, 1);
                            BlockPos zMinusOne = blockPos.m_7918_(0, 0, -1);
                            FluidState fluidStateXP1 = level.m_6425_(xPlusOne);
                            FluidState fluidStateXM1 = level.m_6425_(xMinusOne);
                            FluidState fluidStateZP1 = level.m_6425_(zPlusOne);
                            FluidState fluidStateZM1 = level.m_6425_(zMinusOne);
                            if (!fluidStateXP1.m_76152_().m_6212_(this.m_5613_()) && !fluidStateXP1.m_76152_().m_6212_(this.m_5615_()) && !fluidStateXM1.m_76152_().m_6212_(this.m_5613_()) && !fluidStateXM1.m_76152_().m_6212_(this.m_5615_()) && !fluidStateZP1.m_76152_().m_6212_(this.m_5613_()) && !fluidStateZP1.m_76152_().m_6212_(this.m_5615_()) && !fluidStateZM1.m_76152_().m_6212_(this.m_5613_()) && !fluidStateZM1.m_76152_().m_6212_(this.m_5615_())) continue;
                            foundSource = true;
                            continue block0;
                        }
                    }
                    if (!foundSource) {
                        level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
            BlockState blockstate = level.m_8055_(blockPos);
            BlockPos blockpos = blockPos.m_7494_();
            BlockState blockstate1 = level.m_8055_(blockpos);
            FluidState fluidstate = this.m_76035_(level, blockpos.m_7495_(), blockstate1);
            if (this.m_75977_((BlockGetter)level, blockPos, blockstate, Direction.UP, blockpos, blockstate1, level.m_6425_(blockpos), fluidstate.m_76152_())) {
                this.m_6364_((LevelAccessor)level, blockpos, blockstate1, Direction.UP, fluidstate);
                if (this.sourceNeighborCount((LevelReader)level, blockPos) >= 3 || this.m_7444_(fluidState)) {
                    this.spreadToSides(level, blockPos, fluidState, blockstate);
                }
            } else if (fluidState.m_76170_() || !this.isWaterHole((BlockGetter)level, fluidstate.m_76152_(), blockPos, blockstate, blockpos, blockstate1)) {
                this.spreadToSides(level, blockPos, fluidState, blockstate);
            }
        }
    }

    private void spreadToSides(Level level, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int i = fluidState.m_76186_() - this.m_6713_((LevelReader)level);
        if (((Boolean)fluidState.m_61143_((Property)FALLING)).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map map = this.m_76079_(level, pos, blockState);
            for (Map.Entry entry : map.entrySet()) {
                BlockState blockstate;
                Direction direction = (Direction)entry.getKey();
                FluidState fluidstate = (FluidState)entry.getValue();
                BlockPos blockpos = pos.m_121945_(direction);
                if (!this.m_75977_((BlockGetter)level, pos, blockState, direction, blockpos, blockstate = level.m_8055_(blockpos), level.m_6425_(blockpos), fluidstate.m_76152_())) continue;
                this.m_6364_((LevelAccessor)level, blockpos, blockstate, direction, fluidstate);
            }
        }
    }

    private int sourceNeighborCount(LevelReader levelReader, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction);
            FluidState fluidstate = levelReader.m_6425_(blockpos);
            if (!this.isSourceBlockOfThisType(fluidstate)) continue;
            ++i;
        }
        return i;
    }

    private boolean isSourceBlockOfThisType(FluidState fluidState) {
        return fluidState.m_76152_().m_6212_((Fluid)this) && fluidState.m_76170_();
    }

    private boolean isWaterHole(BlockGetter getter, Fluid fluid, BlockPos pos0, BlockState blockState0, BlockPos pos1, BlockState blockState1) {
        if (!this.canPassThroughWall(Direction.UP, getter, pos0, blockState0, pos1, blockState1)) {
            return false;
        }
        return blockState1.m_60819_().m_76152_().m_6212_((Fluid)this) || this.canHoldFluid(getter, pos1, blockState1, fluid);
    }

    private boolean canPassThroughWall(Direction p_76062_, BlockGetter p_76063_, BlockPos p_76064_, BlockState p_76065_, BlockPos p_76066_, BlockState p_76067_) {
        VoxelShape voxelshape;
        VoxelShape voxelshape1;
        boolean flag;
        Block.BlockStatePairKey block$blockstatepairkey;
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2bytelinkedopenhashmap = !p_76065_.m_60734_().m_49967_() && !p_76067_.m_60734_().m_49967_() ? OCCLUSION_CACHE.get() : null;
        if (object2bytelinkedopenhashmap != null) {
            block$blockstatepairkey = new Block.BlockStatePairKey(p_76065_, p_76067_, p_76062_);
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$blockstatepairkey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            block$blockstatepairkey = null;
        }
        boolean bl = flag = !Shapes.m_83152_((VoxelShape)(voxelshape1 = p_76065_.m_60812_(p_76063_, p_76064_)), (VoxelShape)(voxelshape = p_76067_.m_60812_(p_76063_, p_76066_)), (Direction)p_76062_);
        if (object2bytelinkedopenhashmap != null) {
            if (object2bytelinkedopenhashmap.size() == 200) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$blockstatepairkey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    private boolean canHoldFluid(BlockGetter getter, BlockPos pos, BlockState blockState, Fluid fluid) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            return ((LiquidBlockContainer)block).m_6044_(getter, pos, blockState, fluid);
        }
        if (!(block instanceof DoorBlock || blockState.m_204336_(BlockTags.f_13068_) || blockState.m_60713_(Blocks.f_50155_) || blockState.m_60713_(Blocks.f_50130_) || blockState.m_60713_(Blocks.f_50628_))) {
            if (!(blockState.m_60713_(Blocks.f_50142_) || blockState.m_60713_(Blocks.f_50257_) || blockState.m_60713_(Blocks.f_50446_) || blockState.m_60713_(Blocks.f_50454_))) {
                return !blockState.m_280555_();
            }
            return false;
        }
        return false;
    }

    protected void m_6364_(LevelAccessor accessor, BlockPos pos, BlockState blockStateInQuestion, Direction p_76008_, FluidState fluidState) {
        if (blockStateInQuestion.m_60734_() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockStateInQuestion.m_60734_()).m_7361_(accessor, pos, blockStateInQuestion, fluidState);
        } else {
            if (!blockStateInQuestion.m_60795_()) {
                this.m_7456_(accessor, pos, blockStateInQuestion);
            }
            accessor.m_7731_(pos, fluidState.m_76188_(), 3);
        }
    }

    public boolean m_7444_(FluidState fluidState) {
        return false;
    }

    public int m_7430_(FluidState fluidState) {
        return this.flowWidth;
    }

    public static class Source
    extends VEFlowingGasFluid {
        private final int flowWidth;

        protected Source(ForgeFlowingFluid.Properties properties, int blocksToFlowOutWide) {
            super(properties, blocksToFlowOutWide);
            this.flowWidth = blocksToFlowOutWide;
        }

        @Override
        public int m_7430_(FluidState state) {
            return this.flowWidth;
        }

        @Override
        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends VEFlowingGasFluid {
        protected Flowing(ForgeFlowingFluid.Properties properties, int blocksToFlowOutWide) {
            super(properties, blocksToFlowOutWide);
        }

        @Override
        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        @Override
        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

