/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.datagen;

import com.veteam.voluminousenergy.items.VEItems;
import com.veteam.voluminousenergy.loot.VELoot;
import com.veteam.voluminousenergy.loot.modifiers.AnimalFatLootModifier;
import com.veteam.voluminousenergy.loot.modifiers.MysteriousMultiplierModifier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;

public class VEGlobalLootModifierData
extends GlobalLootModifierProvider {
    public VEGlobalLootModifierData(PackOutput packOutput) {
        super(packOutput, "voluminousenergy");
    }

    protected void start() {
        LootItemCondition fiftyFiftyChanceCondition = LootItemRandomChanceWithLootingCondition.m_81963_((float)0.5f, (float)0.5f).m_6409_();
        LootItemCondition alwaysMetCondition = LootItemRandomChanceCondition.m_81927_((float)1.0f).m_6409_();
        this.animalFatModifierProvider(fiftyFiftyChanceCondition);
        this.mysteriousMultiplierModifierProvider(alwaysMetCondition);
    }

    private void mysteriousMultiplierModifierProvider(LootItemCondition lootCondition) {
        for (ResourceLocation resourceLocation : VELoot.SPAWN_MYSTERIOUS_MULTIPLIERS_IN) {
            String lootTableString = "mysterious_multiplier/" + resourceLocation.m_135815_();
            this.add(lootTableString, (IGlobalLootModifier)new MysteriousMultiplierModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)resourceLocation).m_6409_()}));
        }
    }

    private void animalFatModifierProvider(LootItemCondition lootCondition) {
        this.add("animal_fat_from_black_sheep", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/sheep/black")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 0, 2));
        this.add("animal_fat_from_brown_sheep", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/sheep/brown")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 0, 2));
        this.add("animal_fat_from_gray_sheep", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/sheep/gray")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 0, 2));
        this.add("animal_fat_from_light_gray_sheep", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/sheep/light_gray")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 0, 2));
        this.add("animal_fat_from_pink_sheep", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/sheep/pink")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 0, 2));
        this.add("animal_fat_from_white_sheep", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/sheep/white")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 0, 2));
        this.add("animal_fat_from_pig", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/pig")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 1, 3));
        this.add("animal_fat_from_cow", (IGlobalLootModifier)new AnimalFatLootModifier(new LootItemCondition[]{lootCondition, LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("minecraft", "entities/cow")).m_6409_()}, (Item)VEItems.ANIMAL_FAT.get(), 1, 2));
    }

    @NotNull
    public String m_6055_() {
        return "Voluminous Energy Loot Injection for Global Loot Modifiers";
    }
}

