/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.items.tools.multitool.VEMultitools;
import com.veteam.voluminousenergy.recipe.ToolingRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ToolingCategory
implements IRecipeCategory<ToolingRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.TOOLING_UID, ToolingRecipe.class);

    public ToolingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        ResourceLocation ToolingGUI = new ResourceLocation("voluminousenergy", "textures/gui/tooling_station_gui.png");
        this.background = guiHelper.drawableBuilder(GUI, 68, 12, 70, 50).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEMultitools.IRON_DRILL_MULTITOOL.get()));
        this.arrow = guiHelper.drawableBuilder(ToolingGUI, 188, 0, 22, 47).build();
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.tooling");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ToolingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.slotDrawable.draw(matrixStack, 2, 14);
        this.slotDrawable.draw(matrixStack, 48, 1);
        this.slotDrawable.draw(matrixStack, 48, 29);
        this.arrow.draw(matrixStack, 24, 0);
    }

    public void ingredientHandler(ToolingRecipe recipe, IIngredientAcceptor completeMultitoolItemAcceptor, IIngredientAcceptor bitItemAcceptor, IIngredientAcceptor baseItemAcceptor) {
        bitItemAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(((Ingredient)recipe.ingredient.get()).m_43908_()));
        ArrayList<ItemStack> baseStacks = new ArrayList<ItemStack>();
        for (Item base : recipe.getBases()) {
            baseStacks.add(new ItemStack((ItemLike)base));
        }
        baseItemAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, baseStacks);
        completeMultitoolItemAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.result.m_41777_());
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, ToolingRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder completeMultitoolItem = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 3, 15);
        IRecipeSlotBuilder bitItem = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 49, 2);
        IRecipeSlotBuilder baseItem = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 49, 30);
        completeMultitoolItem.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        bitItem.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        baseItem.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)completeMultitoolItem, (IIngredientAcceptor)bitItem, (IIngredientAcceptor)baseItem);
    }
}

