/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.SawmillingRecipe;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.RegistryLookups;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SawmillCategory
implements IRecipeCategory<SawmillingRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.SAWMILL_UID, SawmillingRecipe.class);

    public SawmillCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 68, 12, 86, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.SAWMILL_BLOCK.get()));
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.sawmilling");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(SawmillingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.slotDrawable.draw(matrixStack, 2, 10);
        this.slotDrawable.draw(matrixStack, 48, 1);
        this.slotDrawable.draw(matrixStack, 48, 19);
        this.slotDrawable.draw(matrixStack, 66, 9);
        this.arrow.draw(matrixStack, 24, 11);
        this.emptyArrow.draw(matrixStack, 24, 11);
    }

    public void ingredientHandler(SawmillingRecipe recipe, IIngredientAcceptor inputItemAcceptor, IIngredientAcceptor primaryItemOutputAcceptor, IIngredientAcceptor secondaryItemOutputAcceptor, IIngredientAcceptor fluidOutputAcceptor) {
        if (recipe.isLogRecipe() && ((Boolean)Config.SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED.get()).booleanValue()) {
            ResourceLocation fluidLocation;
            Fluid outputFluid;
            AtomicReference atomicLogStacks = new AtomicReference(new ArrayList());
            AtomicReference atomicPlankStacks = new AtomicReference(new ArrayList());
            ForgeRegistries.ITEMS.getValues().parallelStream().forEach(registeredItem -> {
                if (RegistryLookups.lookupItem(registeredItem).m_135815_().contains("log")) {
                    ((ArrayList)atomicLogStacks.get()).add(new ItemStack((ItemLike)registeredItem, ((Integer)Config.SAWMILL_LOG_CONSUMPTION_RATE.get()).intValue()));
                } else if (RegistryLookups.lookupItem(registeredItem).m_135815_().contains("plank")) {
                    ((ArrayList)atomicPlankStacks.get()).add(new ItemStack((ItemLike)registeredItem, ((Integer)Config.SAWMILL_PRIMARY_OUTPUT_COUNT.get()).intValue()));
                }
            });
            inputItemAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)atomicLogStacks.get());
            primaryItemOutputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)atomicPlankStacks.get());
            ResourceLocation secondOutputItemResourceLocation = new ResourceLocation((String)Config.SAWMILL_SECOND_OUTPUT_RESOURCE_LOCATION.get());
            Item secondOutput = (Item)ForgeRegistries.ITEMS.getValue(secondOutputItemResourceLocation);
            if (secondOutput != null) {
                secondaryItemOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)secondOutput, ((Integer)Config.SAWMILL_SECOND_OUTPUT_COUNT.get()).intValue()));
            }
            if ((outputFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation = new ResourceLocation((String)Config.SAWMILL_FLUID_LOCATION.get()))) != null) {
                fluidOutputAcceptor.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(outputFluid, ((Integer)Config.SAWMILL_FLUID_AMOUNT.get()).intValue()));
            }
        } else if (!recipe.isLogRecipe()) {
            ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                itemStack.m_41764_(recipe.ingredientCount);
                inputStacks.add(itemStack);
            }
            inputItemAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputStacks);
            ItemStack resultStack = recipe.result.m_41777_();
            resultStack.m_41764_(recipe.getOutputAmount());
            primaryItemOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)resultStack);
            ItemStack secondOutputStack = recipe.secondResult.m_41777_();
            secondOutputStack.m_41764_(recipe.getSecondAmount());
            secondaryItemOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)secondOutputStack);
            fluidOutputAcceptor.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid().copy());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, SawmillingRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder inputItem = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 11);
        IRecipeSlotBuilder primaryOutputItem = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 49, 2);
        IRecipeSlotBuilder secondaryOutputItem = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 49, 20);
        IRecipeSlotBuilder fluidOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 67, 10);
        this.ingredientHandler(recipe, (IIngredientAcceptor)inputItem, (IIngredientAcceptor)primaryOutputItem, (IIngredientAcceptor)secondaryOutputItem, (IIngredientAcceptor)fluidOutput);
    }
}

