/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.IndustrialBlastingRecipe;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class IndustrialBlastingCategory
implements IRecipeCategory<IndustrialBlastingRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.INDUSTRIAL_BLASTING_UID, IndustrialBlastingRecipe.class);

    public IndustrialBlastingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 42, 5, 120, 60).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.BLAST_FURNACE_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.industrial_blasting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IndustrialBlastingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 54, 12);
        this.emptyArrow.draw(matrixStack, 54, 12);
        this.slotDrawable.draw(matrixStack, 30, 1);
        this.slotDrawable.draw(matrixStack, 30, 19);
        this.slotDrawable.draw(matrixStack, 78, 10);
        this.slotDrawable.draw(matrixStack, 5, 10);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, recipe.getMinimumHeat() + " K (" + (recipe.getMinimumHeat() - 273) + " \u00b0C; " + ((int)((double)(recipe.getMinimumHeat() - 273) * 1.8) + 32) + " \u00b0F)", 1, 45, VEContainerScreen.GREY_TEXT_STYLE);
    }

    public void ingredientHandler(IndustrialBlastingRecipe recipe, IIngredientAcceptor firstInputAcceptor, IIngredientAcceptor secondInputAcceptor, IIngredientAcceptor heatFluidAcceptor, IIngredientAcceptor outputItemAcceptor) {
        ArrayList<ItemStack> firstInputStacks = new ArrayList<ItemStack>();
        for (Item inputItem : recipe.getFirstInputAsList()) {
            firstInputStacks.add(new ItemStack((ItemLike)inputItem, recipe.getIngredientCount()));
        }
        firstInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, firstInputStacks);
        AtomicReference atomicSecondInputStack = new AtomicReference(new ArrayList());
        ((ArrayList)recipe.onlySecondInput.get()).parallelStream().forEach(item -> {
            ItemStack secondInputStack = new ItemStack((ItemLike)item, recipe.getSecondInputAmount());
            ((ArrayList)atomicSecondInputStack.get()).add(secondInputStack);
        });
        secondInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)atomicSecondInputStack.get());
        heatFluidAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, RecipeUtil.getFluidsHotEnoughForIndustrialBlastingRecipe(recipe));
        ItemStack resultStack = recipe.result.m_41777_();
        resultStack.m_41764_(recipe.getOutputAmount());
        outputItemAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)resultStack);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, IndustrialBlastingRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder firstItemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 31, 2);
        IRecipeSlotBuilder secondItemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 31, 20);
        IRecipeSlotBuilder heatFluidInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 6, 11);
        IRecipeSlotBuilder itemOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 79, 11);
        firstItemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        secondItemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        heatFluidInput.setSlotName(TextUtil.TRANSLATED_INPUT_TANK.getString());
        itemOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)firstItemInput, (IIngredientAcceptor)secondItemInput, (IIngredientAcceptor)heatFluidInput, (IIngredientAcceptor)itemOutput);
    }
}

