/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.ImplosionCompressorRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ImplosionCompressionCategory
implements IRecipeCategory<ImplosionCompressorRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.IMPLOSION_COMPRESSION_UID, ImplosionCompressorRecipe.class);

    public ImplosionCompressionCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 68, 12, 70, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.IMPLOSION_COMPRESSOR_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.implosion_compressing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ImplosionCompressorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 24, 12);
        this.emptyArrow.draw(matrixStack, 24, 12);
        this.slotDrawable.draw(matrixStack, 2, 1);
        this.slotDrawable.draw(matrixStack, 2, 19);
        this.slotDrawable.draw(matrixStack, 48, 10);
    }

    public void ingredientHandler(ImplosionCompressorRecipe recipe, IIngredientAcceptor itemInputAcceptor, IIngredientAcceptor explosiveInputAcceptor, IIngredientAcceptor itemOutputAcceptor) {
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
            itemStack.m_41764_(recipe.getIngredientCount());
            inputStacks.add(itemStack);
        }
        itemInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputStacks);
        explosiveInputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42403_, recipe.ingredientCount));
        ItemStack resultStack = recipe.result.m_41777_();
        resultStack.m_41764_(recipe.getOutputAmount());
        itemOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)resultStack);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, ImplosionCompressorRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder itemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 2);
        IRecipeSlotBuilder explosiveInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 20);
        IRecipeSlotBuilder itemOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 49, 11);
        itemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        explosiveInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        itemOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)itemInput, (IIngredientAcceptor)explosiveInput, (IIngredientAcceptor)itemOutput);
    }
}

