/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.HydroponicIncubatorRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class HydroponicIncubatorCategory
implements IRecipeCategory<HydroponicIncubatorRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.HYDROPONIC_INCUBATOR_UID, HydroponicIncubatorRecipe.class);

    public HydroponicIncubatorCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 4, 4, 156, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.HYDROPONIC_INCUBATOR_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.hydroponic_incubating");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(HydroponicIncubatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        int xPos;
        int chance;
        this.arrow.draw(matrixStack, 48, 12);
        this.emptyArrow.draw(matrixStack, 48, 12);
        this.slotDrawable.draw(matrixStack, 2, 10);
        this.slotDrawable.draw(matrixStack, 24, 10);
        this.slotDrawable.draw(matrixStack, 72, 10);
        this.slotDrawable.draw(matrixStack, 94, 10);
        this.slotDrawable.draw(matrixStack, 116, 10);
        this.slotDrawable.draw(matrixStack, 138, 10);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "mB:", 2, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getInputAmount(), 24, 32, VEContainerScreen.GREY_TEXT_STYLE);
        if (recipe.getChance0() > 0.0f) {
            chance = (int)(recipe.getChance0() * 100.0f);
            xPos = this.calculateXPos(94, chance);
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, chance + "%", xPos, 32, VEContainerScreen.GREY_TEXT_STYLE);
        }
        if (recipe.getChance1() > 0.0f) {
            chance = (int)(recipe.getChance1() * 100.0f);
            xPos = this.calculateXPos(116, chance);
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, chance + "%", xPos, 32, VEContainerScreen.GREY_TEXT_STYLE);
        }
        if (recipe.getChance2() > 0.0f) {
            chance = (int)(recipe.getChance2() * 100.0f);
            xPos = this.calculateXPos(138, chance);
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, chance + "%", xPos, 32, VEContainerScreen.GREY_TEXT_STYLE);
        }
    }

    private int calculateXPos(int xPos, int chance) {
        if (chance < 100 && chance > 9) {
            xPos += 3;
        } else if (chance < 10) {
            xPos += 5;
        }
        return xPos;
    }

    public void ingredientHandler(HydroponicIncubatorRecipe recipe, IIngredientAcceptor itemInputAcceptor, IIngredientAcceptor fluidInputAcceptor, IIngredientAcceptor primaryOutputAcceptor, IIngredientAcceptor rng0OutputAccepter, IIngredientAcceptor rng1OutputAccepter, IIngredientAcceptor rng2OutputAccepter) {
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (ItemStack testStack : recipe.getIngredient().m_43908_()) {
            testStack.m_41764_(recipe.getIngredientCount());
            inputList.add(testStack);
        }
        itemInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputList);
        fluidInputAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, (List)recipe.fluidInputList.get());
        ItemStack primaryOutputStack = recipe.getResult().m_41777_();
        primaryOutputStack.m_41764_(recipe.getOutputAmount());
        primaryOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)primaryOutputStack);
        ItemStack rng0Stack = recipe.getRngItemSlot0().m_41777_();
        rng0Stack.m_41764_(recipe.getOutputRngAmount0());
        rng0OutputAccepter.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rng0Stack);
        ItemStack rng1Stack = recipe.getRngItemSlot1().m_41777_();
        rng1Stack.m_41764_(recipe.getOutputRngAmount1());
        rng1OutputAccepter.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rng1Stack);
        ItemStack rng2Stack = recipe.getRngItemSlot2().m_41777_();
        rng2Stack.m_41764_(recipe.getOutputRngAmount2());
        rng2OutputAccepter.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rng2Stack);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, HydroponicIncubatorRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder itemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 11);
        IRecipeSlotBuilder fluidInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 25, 11);
        IRecipeSlotBuilder primaryOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 11);
        IRecipeSlotBuilder rng0Output = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 95, 11);
        IRecipeSlotBuilder rng1Output = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 117, 11);
        IRecipeSlotBuilder rng2Output = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 139, 11);
        itemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        fluidInput.setSlotName(TextUtil.TRANSLATED_INPUT_TANK.getString());
        primaryOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        rng0Output.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        rng1Output.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        rng2Output.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)itemInput, (IIngredientAcceptor)fluidInput, (IIngredientAcceptor)primaryOutput, (IIngredientAcceptor)rng0Output, (IIngredientAcceptor)rng1Output, (IIngredientAcceptor)rng2Output);
    }
}

