/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.FluidMixerRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FluidMixingCategory
implements IRecipeCategory<FluidMixerRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.FLUID_MIXER_UID, FluidMixerRecipe.class);

    public FluidMixingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 68, 12, 90, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.FLUID_MIXER_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.fluid_mixing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(FluidMixerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 48, 12);
        this.emptyArrow.draw(matrixStack, 48, 12);
        this.slotDrawable.draw(matrixStack, 2, 10);
        this.slotDrawable.draw(matrixStack, 24, 10);
        this.slotDrawable.draw(matrixStack, 72, 10);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "mB:", -20, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getInputAmount(), 2, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getSecondInputAmount(), 24, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getOutputAmount(), 72, 32, VEContainerScreen.GREY_TEXT_STYLE);
    }

    public void ingredientHandler(FluidMixerRecipe recipe, IIngredientAcceptor firstFluidInputAcceptor, IIngredientAcceptor secondFluidInputAcceptor, IIngredientAcceptor outputFluidAccepetor) {
        firstFluidInputAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, (List)recipe.fluidInputList.get());
        secondFluidInputAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, (List)recipe.secondFluidInputList.get());
        outputFluidAccepetor.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, FluidMixerRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder firstInputFluid = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 11);
        IRecipeSlotBuilder secondInputFluid = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 25, 11);
        IRecipeSlotBuilder outputFluid = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 11);
        firstInputFluid.setSlotName(TextUtil.TRANSLATED_INPUT_TANK.getString());
        secondInputFluid.setSlotName(TextUtil.TRANSLATED_INPUT_TANK.getString());
        outputFluid.setSlotName(TextUtil.TRANSLATED_OUTPUT_TANK.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)firstInputFluid, (IIngredientAcceptor)secondInputFluid, (IIngredientAcceptor)outputFluid);
    }
}

