/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.ElectrolyzerRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ElectrolyzingCategory
implements IRecipeCategory<ElectrolyzerRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.ELECTROLYZING_UID, ElectrolyzerRecipe.class);

    public ElectrolyzingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 52, 5, 120, 78).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.ELECTROLYZER_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.electrolyzing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ElectrolyzerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        int chance;
        this.arrow.draw(matrixStack, 25, 30);
        this.emptyArrow.draw(matrixStack, 25, 30);
        this.slotDrawable.draw(matrixStack, 5, 20);
        this.slotDrawable.draw(matrixStack, 5, 38);
        this.slotDrawable.draw(matrixStack, 49, 2);
        this.slotDrawable.draw(matrixStack, 49, 20);
        this.slotDrawable.draw(matrixStack, 49, 38);
        this.slotDrawable.draw(matrixStack, 49, 56);
        if (recipe.getRngItemSlot0() != null && recipe.getRngItemSlot0().m_41720_() != Items.f_41852_) {
            chance = (int)(recipe.getChance0() * 100.0f);
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(chance + "%")), 74, 26, VEContainerScreen.GREY_TEXT_STYLE);
        }
        if (recipe.getRngItemSlot1() != null && recipe.getRngItemSlot1().m_41720_() != Items.f_41852_) {
            chance = (int)(recipe.getChance1() * 100.0f);
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(chance + "%")), 74, 44, VEContainerScreen.GREY_TEXT_STYLE);
        }
        if (recipe.getRngItemSlot2() != null && recipe.getRngItemSlot2().m_41720_() != Items.f_41852_) {
            chance = (int)(recipe.getChance2() * 100.0f);
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(chance + "%")), 74, 62, VEContainerScreen.GREY_TEXT_STYLE);
        }
    }

    public void ingredientHandler(ElectrolyzerRecipe recipe, IIngredientAcceptor itemInputAcceptor, IIngredientAcceptor bucketInputAcceptor, IIngredientAcceptor primaryOutputAcceptor, IIngredientAcceptor rng0OutputAcceptor, IIngredientAcceptor rng1OutputAcceptor, IIngredientAcceptor rng2OutputAcceptor) {
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
            itemStack.m_41764_(recipe.ingredientCount);
            inputStacks.add(itemStack);
        }
        itemInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputStacks);
        if (recipe.needsBuckets() > 0) {
            ItemStack bucketStack = new ItemStack((ItemLike)Items.f_42446_, recipe.needsBuckets());
            bucketInputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)bucketStack);
        }
        ItemStack primaryOutputStack = recipe.result.m_41777_();
        primaryOutputStack.m_41764_(recipe.getOutputAmount());
        primaryOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)primaryOutputStack);
        ItemStack rng0 = recipe.getRngItemSlot0().m_41777_();
        rng0.m_41764_(recipe.getOutputRngAmount0());
        rng0OutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rng0);
        ItemStack rng1 = recipe.getRngItemSlot1().m_41777_();
        rng1.m_41764_(recipe.getOutputRngAmount1());
        rng1OutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rng1);
        ItemStack rng2 = recipe.getRngItemSlot2().m_41777_();
        rng2.m_41764_(recipe.getOutputRngAmount2());
        rng2OutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rng2);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, ElectrolyzerRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder itemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 6, 21);
        IRecipeSlotBuilder bucketInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 6, 39);
        IRecipeSlotBuilder itemOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 50, 3);
        IRecipeSlotBuilder rng0Output = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 50, 21);
        IRecipeSlotBuilder rng1Output = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 50, 39);
        IRecipeSlotBuilder rng2Output = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 50, 57);
        itemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        bucketInput.setSlotName(TextUtil.TRANSLATED_BUCKET_SLOT.getString());
        itemOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        rng0Output.setSlotName(TextUtil.TRANSLATED_RNG_SLOT.getString());
        rng1Output.setSlotName(TextUtil.TRANSLATED_RNG_SLOT.getString());
        rng2Output.setSlotName(TextUtil.TRANSLATED_RNG_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)itemInput, (IIngredientAcceptor)bucketInput, (IIngredientAcceptor)itemOutput, (IIngredientAcceptor)rng0Output, (IIngredientAcceptor)rng1Output, (IIngredientAcceptor)rng2Output);
    }
}

