/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.DistillationRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DistillingCategory
implements IRecipeCategory<DistillationRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.DISTILLING_UID, DistillationRecipe.class);

    public DistillingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 42, 5, 128, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.DISTILLATION_UNIT_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.distilling");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(DistillationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 24, 12);
        this.emptyArrow.draw(matrixStack, 24, 12);
        this.slotDrawable.draw(matrixStack, 2, 10);
        this.slotDrawable.draw(matrixStack, 48, 10);
        this.slotDrawable.draw(matrixStack, 72, 10);
        this.slotDrawable.draw(matrixStack, 96, 10);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "mB:", -20, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getInputAmount(), 2, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getOutputAmount(), 48, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, "" + recipe.getAmounts().get(2), 72, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, (int)(recipe.getThirdChance() * 100.0f) + "%", 96, 32, VEContainerScreen.GREY_TEXT_STYLE);
    }

    public void ingredientHandler(DistillationRecipe recipe, IIngredientAcceptor fluidInputAcceptor, IIngredientAcceptor firstFluidOutputAcceptor, IIngredientAcceptor secondFluidOutputAcceptor, IIngredientAcceptor itemOutputAcceptor) {
        fluidInputAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, (List)recipe.fluidInputList.get());
        firstFluidOutputAcceptor.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
        secondFluidOutputAcceptor.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getSecondFluid());
        ItemStack itemStackResult = recipe.getThirdResult().m_41777_();
        itemStackResult.m_41764_(recipe.getThirdAmount());
        itemOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStackResult);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, DistillationRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder fluidInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 11);
        IRecipeSlotBuilder firstFluidOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 49, 11);
        IRecipeSlotBuilder secondFluidOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 11);
        IRecipeSlotBuilder itemOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 97, 11);
        fluidInput.setSlotName(TextUtil.TRANSLATED_INPUT_TANK.getString());
        firstFluidOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_TANK.getString());
        secondFluidOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_TANK.getString());
        itemOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)fluidInput, (IIngredientAcceptor)firstFluidOutput, (IIngredientAcceptor)secondFluidOutput, (IIngredientAcceptor)itemOutput);
    }
}

