/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.DimensionalLaserRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class DimensionalLasingCategory
implements IRecipeCategory<DimensionalLaserRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.DIMENSIONAL_LASER_UID, DimensionalLaserRecipe.class);

    public DimensionalLasingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        ResourceLocation dimensionalLaserGUI = new ResourceLocation("voluminousenergy", "textures/gui/dimensional_laser_gui.png");
        this.background = guiHelper.drawableBuilder(GUI, 42, 5, 128, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.DIMENSIONAL_LASER_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(dimensionalLaserGUI, 97, 34, 15, 16).build();
        this.emptyArrow = guiHelper.drawableBuilder(dimensionalLaserGUI, 176, 0, 15, 17).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.dimensional_lasing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(DimensionalLaserRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 9, 4);
        this.emptyArrow.draw(matrixStack, 9, 4);
        this.slotDrawable.draw(matrixStack, 8, 22);
        int xPos = 36;
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)("C: " + recipe.getFluidClimateSpawn().getContinentalnessClimateParameter().getA() + " ~ " + recipe.getFluidClimateSpawn().getContinentalnessClimateParameter().getB())), xPos, -1, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)("E: " + recipe.getFluidClimateSpawn().getErosionClimateParameter().getA() + " ~ " + recipe.getFluidClimateSpawn().getErosionClimateParameter().getB())), xPos, 9, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)("H: " + recipe.getFluidClimateSpawn().getHumidityClimateParameter().getA() + " ~ " + recipe.getFluidClimateSpawn().getHumidityClimateParameter().getB())), xPos, 19, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)("T: " + recipe.getFluidClimateSpawn().getTemperatureClimateParameter().getA() + " ~ " + recipe.getFluidClimateSpawn().getTemperatureClimateParameter().getB())), xPos, 29, VEContainerScreen.GREY_TEXT_STYLE);
    }

    public void ingredientHandler(DimensionalLaserRecipe recipe, IIngredientAcceptor fluidOutputAcceptor) {
        fluidOutputAcceptor.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.getFluidClimateSpawn().getFluid(), 1000));
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, DimensionalLaserRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder fluidOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 9, 23);
        fluidOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_TANK.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)fluidOutput);
    }
}

