/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.CrusherScreen;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.CrusherRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CrushingCategory
implements IRecipeCategory<CrusherRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.CRUSHING_UID, CrusherRecipe.class);

    public CrushingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(CrusherScreen.getGUI(), 68, 12, 40, 70).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.CRUSHER_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(CrusherScreen.getGUI(), 176, 0, 17, 24).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.crushing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrusherRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 10, 19);
        if (recipe.getRngItem() != null && recipe.getRngItem().m_41720_() != Items.f_41852_) {
            int chance = (int)(recipe.getChance() * 100.0f);
            int xPos = 20;
            if (chance < 100 && chance >= 10) {
                xPos += 3;
            } else if (chance < 10) {
                xPos += 5;
            }
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(chance + "%")), xPos, 65, VEContainerScreen.GREY_TEXT_STYLE);
        }
    }

    public void ingredientHandler(CrusherRecipe recipe, IIngredientAcceptor itemInputAcceptor, IIngredientAcceptor itemOutputAcceptor, IIngredientAcceptor itemRNGOutputAcceptor) {
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
            itemStack.m_41764_(recipe.ingredientCount);
            inputStacks.add(itemStack);
        }
        itemInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputStacks);
        ItemStack resultStack = recipe.result.m_41777_();
        resultStack.m_41764_(recipe.getOutputAmount());
        itemOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)resultStack);
        ItemStack rngStack = recipe.rngResult.m_41777_();
        rngStack.m_41764_(recipe.getOutputRngAmount());
        itemRNGOutputAcceptor.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rngStack);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, CrusherRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder itemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 12, 1);
        IRecipeSlotBuilder primaryItemOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 3, 46);
        IRecipeSlotBuilder rngItemOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 21, 46);
        itemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        primaryItemOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_SLOT.getString());
        rngItemOutput.setSlotName(TextUtil.TRANSLATED_RNG_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)itemInput, (IIngredientAcceptor)primaryItemOutput, (IIngredientAcceptor)rngItemOutput);
    }
}

