/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorFuelRecipe;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorOxidizerRecipe;
import com.veteam.voluminousenergy.util.NumberUtil;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CombustionCategory
implements IRecipeCategory<CombustionGeneratorFuelRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.COMBUSTING_UID, CombustionGeneratorFuelRecipe.class);

    public CombustionCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/combustion_generator.png");
        this.background = guiHelper.drawableBuilder(GUI, 52, 5, 120, 64).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.COMBUSTION_GENERATOR_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.combustion");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CombustionGeneratorFuelRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        TextUtil.renderShadowedText(matrixStack, Minecraft.m_91087_().f_91062_, (Component)TextUtil.translateString("jei.voluminousenergy.volumetric_energy").m_6881_().m_130946_(": "), 16, 4, VEContainerScreen.WHITE_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(recipe.getVolumetricEnergy() + " FE/B")), 35, 16, VEContainerScreen.GREY_TEXT_STYLE);
        this.slotDrawable.draw(matrixStack, 17, 35);
        this.slotDrawable.draw(matrixStack, 85, 35);
        Optional oxiStack = ((IRecipeSlotView)slotsView.getSlotViews(RecipeIngredientRole.CATALYST).get(0)).getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
        if (oxiStack.isPresent()) {
            CombustionGeneratorOxidizerRecipe oxidizerRecipe = RecipeUtil.getOxidizerCombustionRecipeWithoutLevel((FluidStack)oxiStack.get());
            int fePerTick = recipe.getVolumetricEnergy() / oxidizerRecipe.getProcessTime();
            Component fePerTickComponent = Component.m_130674_((String)("" + fePerTick));
            int x = 50;
            if (fePerTick < 100) {
                x = 54;
            } else if (fePerTick > 999 && fePerTick < 10000) {
                x = 46;
            } else if (fePerTick > 9999) {
                NumberUtil.numberToTextComponent4FE(fePerTick);
                x = 46;
            }
            TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, fePerTickComponent, x, 45, VEContainerScreen.GREY_TEXT_STYLE);
        }
        TextUtil.renderShadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)"FE/t:"), 48, 35, VEContainerScreen.WHITE_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, (Component)TextUtil.translateString("jei.voluminousenergy.fluid.fuel").m_6881_().m_130946_(":"), 16, 26, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, (Component)TextUtil.translateString("jei.voluminousenergy.fluid.oxidizer").m_6881_().m_130946_(":"), 76, 26, VEContainerScreen.GREY_TEXT_STYLE);
    }

    public void ingredientHandler(CombustionGeneratorFuelRecipe recipe, IIngredientAcceptor fuelAcceptor, IIngredientAcceptor oxidizerAcceptor) {
        ArrayList<FluidStack> fuelStacks = new ArrayList<FluidStack>();
        for (Fluid fluid : (ArrayList)recipe.rawFluidInputList.get()) {
            fuelStacks.add(new FluidStack(fluid, 1000));
        }
        fuelAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fuelStacks);
        ArrayList<FluidStack> oxiStacks = new ArrayList<FluidStack>();
        for (CombustionGeneratorOxidizerRecipe oxidizerRecipe : CombustionGeneratorOxidizerRecipe.oxidizerRecipes) {
            for (Fluid fluid : (ArrayList)oxidizerRecipe.rawFluidInputList.get()) {
                oxiStacks.add(new FluidStack(fluid, 1000));
            }
        }
        oxidizerAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, oxiStacks);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, CombustionGeneratorFuelRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder fuel = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 18, 36);
        IRecipeSlotBuilder oxidizer = recipeLayout.addSlot(RecipeIngredientRole.CATALYST, 86, 36);
        this.ingredientHandler(recipe, (IIngredientAcceptor)fuel, (IIngredientAcceptor)oxidizer);
    }
}

