/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.compat.jei.category;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.compat.jei.VoluminousEnergyPlugin;
import com.veteam.voluminousenergy.recipe.AqueoulizerRecipe;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AqueoulizingCategory
implements IRecipeCategory<AqueoulizerRecipe> {
    private final IDrawable background;
    private IDrawable icon;
    private IDrawable slotDrawable;
    private IDrawable arrow;
    private IDrawable emptyArrow;
    public static final RecipeType RECIPE_TYPE = new RecipeType(VoluminousEnergyPlugin.AQUEOULIZING_UID, AqueoulizerRecipe.class);

    public AqueoulizingCategory(IGuiHelper guiHelper) {
        ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/jei/jei.png");
        this.background = guiHelper.drawableBuilder(GUI, 68, 12, 90, 40).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VEBlocks.AQUEOULIZER_BLOCK.get()));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.drawableBuilder(GUI, 176, 0, 23, 17).build();
        this.emptyArrow = guiHelper.drawableBuilder(GUI, 199, 0, 23, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    @NotNull
    public RecipeType getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextUtil.translateString("jei.voluminousenergy.aqueoulizing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AqueoulizerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 48, 12);
        this.emptyArrow.draw(matrixStack, 48, 12);
        this.slotDrawable.draw(matrixStack, 2, 10);
        this.slotDrawable.draw(matrixStack, 24, 10);
        this.slotDrawable.draw(matrixStack, 72, 10);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)"mB:"), 2, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)("" + recipe.getInputAmount())), 24, 32, VEContainerScreen.GREY_TEXT_STYLE);
        TextUtil.renderUnshadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)("" + recipe.getOutputAmount())), 72, 32, VEContainerScreen.GREY_TEXT_STYLE);
    }

    public void ingredientHandler(AqueoulizerRecipe recipe, IIngredientAcceptor itemInputAcceptor, IIngredientAcceptor fluidInputAcceptor, IIngredientAcceptor fluidOutputAcceptor) {
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (ItemStack testStack : recipe.getIngredient().m_43908_()) {
            testStack.m_41764_(recipe.getIngredientCount());
            inputList.add(testStack);
        }
        itemInputAcceptor.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputList);
        fluidInputAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, (List)recipe.fluidInputList.get());
        ArrayList<FluidStack> outputStacks = new ArrayList<FluidStack>();
        outputStacks.add(recipe.getOutputFluid());
        fluidOutputAcceptor.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, outputStacks);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, AqueoulizerRecipe recipe, IFocusGroup focusGroup) {
        IRecipeSlotBuilder itemInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 3, 11);
        IRecipeSlotBuilder fluidInput = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 25, 11);
        IRecipeSlotBuilder fluidOutput = recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 11);
        itemInput.setSlotName(TextUtil.TRANSLATED_INPUT_SLOT.getString());
        this.ingredientHandler(recipe, (IIngredientAcceptor)itemInput, (IIngredientAcceptor)fluidInput, (IIngredientAcceptor)fluidOutput);
        fluidInput.setSlotName(TextUtil.TRANSLATED_INPUT_TANK.getString());
        fluidOutput.setSlotName(TextUtil.TRANSLATED_OUTPUT_TANK.getString());
    }
}

