/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles.tank;

import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TankTile
extends VEFluidTileEntity {
    private final RelationalTank tank = new RelationalTank(new FluidTank(0), 0, null, null, TankType.BOTH, "tank:tank_gui");
    public VESlotManager bucketTopSlotManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "bucket_top_slot");
    public VESlotManager bucketBottomSlotManager = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "bucket_bottom_slot");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(TankTile.this.bucketBottomSlotManager);
            this.add(TankTile.this.bucketTopSlotManager);
        }
    };
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(TankTile.this.tank);
        }
    };
    private final ItemStackHandler inventory = this.createHandler();

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public TankTile(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int capacity) {
        super(blockEntityType, pos, state);
        this.tank.getTank().setCapacity(capacity *= 1000);
        this.tank.setAllowAny(true);
        this.tank.setIgnoreDirection(true);
    }

    public TankTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack bucketTop = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack bucketBottom = this.inventory.getStackInSlot(1).m_41777_();
        this.tank.setInput(bucketTop.m_41777_());
        this.tank.setOutput(bucketBottom.m_41777_());
        if (this.inputFluid(this.tank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.tank, 0, 1)) {
            return;
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                TankTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (stack.m_41720_() instanceof BucketItem) {
                    return true;
                }
                return stack.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public RelationalTank getTank() {
        return this.tank;
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player player) {
        return null;
    }

    @Override
    public int getTankCapacity() {
        return this.tank.getTank().getCapacity();
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }
}

