/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPowerGenerator;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.items.VEItems;
import com.veteam.voluminousenergy.items.upgrades.MysteriousMultiplier;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.energy.VEEnergyStorage;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.MultiFluidSlotWrapper;
import com.veteam.voluminousenergy.util.MultiSlotWrapper;
import com.veteam.voluminousenergy.util.RegistryLookups;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public abstract class VoluminousTileEntity
extends BlockEntity
implements MenuProvider {
    LazyOptional<VEEnergyStorage> energy = this.createEnergy();
    int counter = 0;
    int length = 0;
    int sound_tick = 0;

    public VoluminousTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, VoluminousTileEntity voluminousTile) {
        voluminousTile.tick();
    }

    public abstract void tick();

    public void updateClients() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
    }

    protected int calculateCounter(int processTime, ItemStack upgradeStack) {
        if (upgradeStack.m_41720_() == VEItems.QUARTZ_MULTIPLIER.get()) {
            int count = upgradeStack.m_41613_();
            if (count == 4) {
                return 5;
            }
            return -45 * upgradeStack.m_41613_() + processTime;
        }
        if (!upgradeStack.m_41619_() && TagUtil.isTaggedMachineUpgradeItem(upgradeStack)) {
            CompoundTag compound = upgradeStack.m_41783_();
            return compound != null ? (int)((float)processTime * compound.m_128457_("multiplier")) : processTime;
        }
        return processTime;
    }

    protected int consumptionMultiplier(int consumption, ItemStack upgradeStack) {
        if (upgradeStack.m_41720_() == VEItems.QUARTZ_MULTIPLIER.get()) {
            int count = upgradeStack.m_41613_();
            if (count == 4) {
                return consumption * 16;
            }
            if (count == 3) {
                return consumption * 8;
            }
            if (count == 2) {
                return consumption * 4;
            }
            if (count == 1) {
                return consumption * 2;
            }
        } else if (!upgradeStack.m_41619_() && TagUtil.isTaggedMachineUpgradeItem(upgradeStack)) {
            CompoundTag compound = upgradeStack.m_41783_();
            float multiplier = compound != null ? compound.m_128457_("multiplier") : 1.0f;
            MysteriousMultiplier.QualityTier qualityTier = MysteriousMultiplier.getQualityTier(multiplier);
            return switch (qualityTier) {
                default -> throw new IncompatibleClassChangeError();
                case MysteriousMultiplier.QualityTier.NULL -> consumption;
                case MysteriousMultiplier.QualityTier.BASIC -> (int)((double)consumption * 1.15);
                case MysteriousMultiplier.QualityTier.GRAND -> (int)((double)consumption * 1.25);
                case MysteriousMultiplier.QualityTier.RARE -> (int)((double)consumption * 1.5);
                case MysteriousMultiplier.QualityTier.ARCANE -> consumption * 2;
                case MysteriousMultiplier.QualityTier.HEROIC -> consumption * 4;
                case MysteriousMultiplier.QualityTier.UNIQUE -> consumption * 6;
                case MysteriousMultiplier.QualityTier.CELESTIAL -> consumption * 8;
                case MysteriousMultiplier.QualityTier.DIVINE -> consumption * 10;
                case MysteriousMultiplier.QualityTier.EPIC -> consumption * 12;
                case MysteriousMultiplier.QualityTier.LEGENDARY -> consumption * 14;
                case MysteriousMultiplier.QualityTier.MYTHIC -> consumption * 16;
            };
        }
        return consumption;
    }

    protected int getEnergyStored() {
        return this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public void updatePacketFromGui(boolean status, int slotId) {
        for (VESlotManager slot : this.getSlotManagers()) {
            if (slotId != slot.getSlotNum()) continue;
            slot.setStatus(status);
            return;
        }
    }

    public void updatePacketFromGui(int direction, int slotId) {
        for (VESlotManager slot : this.getSlotManagers()) {
            if (slotId != slot.getSlotNum()) continue;
            slot.setDirection(direction);
            return;
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void m_142466_(CompoundTag tag) {
        CompoundTag inv = tag.m_128469_("inv");
        ItemStackHandler handler = this.getInventoryHandler();
        if (handler != null) {
            handler.deserializeNBT(inv);
        }
        if (this.energy != null) {
            this.energy.ifPresent(h -> h.deserializeNBT(tag));
        }
        if (this instanceof IVECountable) {
            this.counter = tag.m_128451_("counter");
            this.length = tag.m_128451_("length");
        }
        for (VESlotManager manager : this.getSlotManagers()) {
            manager.read(tag);
        }
        super.m_142466_(tag);
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        ItemStackHandler handler = this.getInventoryHandler();
        if (handler != null) {
            CompoundTag compound = (CompoundTag)handler.serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        }
        if (this.energy != null) {
            this.energy.ifPresent(h -> h.serializeNBT(tag));
        }
        for (VESlotManager manager : this.getSlotManagers()) {
            manager.write(tag);
        }
        if (this instanceof IVECountable) {
            tag.m_128405_("counter", this.counter);
            tag.m_128405_("length", this.length);
        }
        super.m_183515_(tag);
    }

    public ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                VoluminousTileEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public ItemStackHandler createHandler(int size, final IVEPoweredTileEntity tileEntity) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                VoluminousTileEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (tileEntity.getUpgradeSlotId() == slot) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == tileEntity.getUpgradeSlotId()) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack) ? super.insertItem(slot, stack, simulate) : stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        VoluminousTileEntity modifiedSide2;
        ItemStackHandler inventory = this.getInventoryHandler();
        List<VESlotManager> itemManagers = this.getSlotManagers();
        if (inventory != null && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return LazyOptional.of(() -> inventory).cast();
            }
            Direction modifiedSide2 = this.normalizeDirection(side);
            List<VESlotManager> managerList = itemManagers.stream().filter(manager -> manager.getStatus() && manager.getDirection().m_122411_() == modifiedSide2.m_122411_()).toList();
            if (managerList.size() == 0) {
                return super.getCapability(cap, side);
            }
            MultiSlotWrapper slotWrapper = new MultiSlotWrapper((IItemHandlerModifiable)inventory, managerList);
            return LazyOptional.of(() -> slotWrapper).cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.energy != null) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null && (modifiedSide2 = this) instanceof VEFluidTileEntity) {
            VEFluidTileEntity veFluidTileEntity = (VEFluidTileEntity)modifiedSide2;
            modifiedSide2 = this.normalizeDirection(side);
            List<RelationalTank> relationalTanks = veFluidTileEntity.getRelationalTanks().stream().filter(arg_0 -> VoluminousTileEntity.lambda$getCapability$5((Direction)modifiedSide2, arg_0)).toList();
            if (relationalTanks.size() == 0) {
                return super.getCapability(cap, side);
            }
            MultiFluidSlotWrapper slotWrapper = new MultiFluidSlotWrapper(relationalTanks);
            return LazyOptional.of(() -> slotWrapper).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public LazyOptional<VEEnergyStorage> createEnergy() {
        VoluminousTileEntity voluminousTileEntity = this;
        if (voluminousTileEntity instanceof IVEPoweredTileEntity) {
            IVEPoweredTileEntity IVEPoweredTileEntity2 = (IVEPoweredTileEntity)((Object)voluminousTileEntity);
            VEEnergyStorage storage = new VEEnergyStorage(IVEPoweredTileEntity2.getMaxPower(), IVEPoweredTileEntity2.getTransferRate());
            if (this instanceof IVEPowerGenerator) {
                storage.setMaxReceive(0);
            }
            return LazyOptional.of(() -> storage);
        }
        return null;
    }

    public void consumeEnergy() {
        VoluminousTileEntity voluminousTileEntity = this;
        if (!(voluminousTileEntity instanceof IVEPoweredTileEntity)) {
            throw new NotImplementedException("Missing implementation of IVEPoweredTileEntity in class: " + ((Object)((Object)this)).getClass().getName());
        }
        IVEPoweredTileEntity IVEPoweredTileEntity2 = (IVEPoweredTileEntity)((Object)voluminousTileEntity);
        this.energy.ifPresent(e -> e.consumeEnergy(this.consumptionMultiplier(IVEPoweredTileEntity2.getPowerUsage(), this.getInventoryHandler().getStackInSlot(IVEPoweredTileEntity2.getUpgradeSlotId()).m_41777_())));
    }

    public boolean canConsumeEnergy() {
        VoluminousTileEntity voluminousTileEntity = this;
        if (voluminousTileEntity instanceof IVEPoweredTileEntity) {
            IVEPoweredTileEntity ivePoweredTileEntity = (IVEPoweredTileEntity)((Object)voluminousTileEntity);
            return this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) > this.consumptionMultiplier(ivePoweredTileEntity.getPowerUsage(), this.getInventoryHandler().getStackInSlot(ivePoweredTileEntity.getUpgradeSlotId()).m_41777_());
        }
        throw new NotImplementedException("Missing implementation of IVEPoweredTileEntity in class: " + ((Object)((Object)this)).getClass().getName());
    }

    @Nonnull
    public Component m_5446_() {
        ResourceLocation name = RegistryLookups.getBlockEntityTypeKey(this);
        if (name == null) {
            throw new NotImplementedException("Missing registry name for class: " + ((Object)((Object)this)).getClass().getName());
        }
        return Component.m_130674_((String)name.m_135815_());
    }

    @Nullable
    public abstract AbstractContainerMenu m_7208_(int var1, @NotNull Inventory var2, @NotNull Player var3);

    @Nullable
    public abstract ItemStackHandler getInventoryHandler();

    @Nonnull
    public abstract List<VESlotManager> getSlotManagers();

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.energy != null) {
            this.energy.ifPresent(e -> e.setEnergy(pkt.m_131708_().m_128451_("energy")));
        }
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Direction normalizeDirection(Direction direction) {
        Direction currentDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        int directionInt = direction.m_122411_();
        if (directionInt == 0 || directionInt == 1) {
            return direction;
        }
        Direction rotated = currentDirection;
        for (int i = 0; i < 4; ++i) {
            rotated = rotated.m_122427_();
            direction = direction.m_122427_();
            if (rotated.m_122411_() == 2) break;
        }
        return direction.m_122427_().m_122427_();
    }

    public LazyOptional<VEEnergyStorage> getEnergy() {
        return this.energy;
    }

    public int decrementCounterOnNoPower(int localCounter) {
        return localCounter < this.length ? localCounter + (Integer)Config.DECREMENT_SPEED_ON_NO_POWER.get() : this.length;
    }

    public void decrementSuperCounterOnNoPower() {
        this.counter = this.counter < this.length ? this.counter + (Integer)Config.DECREMENT_SPEED_ON_NO_POWER.get() : this.length;
        this.m_6596_();
    }

    private static /* synthetic */ boolean lambda$getCapability$5(Direction modifiedSide, RelationalTank manager) {
        return manager.getSideStatus() && manager.getSideDirection().m_122411_() == modifiedSide.m_122411_() || manager.isIgnoreDirection();
    }
}

