/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.tiles.IFluidTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.IntToDirection;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.TankType;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class VEFluidTileEntity
extends VoluminousTileEntity
implements IFluidTileEntity {
    public static final int TANK_CAPACITY = 4000;

    public VEFluidTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean inputFluid(RelationalTank tank, int slot1, int slot2) {
        ItemStack input = tank.getInput();
        ItemStack output = tank.getOutput();
        FluidTank inputTank = tank.getTank();
        ItemStackHandler handler = this.getInventoryHandler();
        if (input.m_41777_().m_41720_() instanceof BucketItem && input.m_41777_().m_41720_() != Items.f_42446_ && (output.m_41777_().m_41720_() == Items.f_42446_ && output.m_41777_().m_41613_() < 16 || VEFluidTileEntity.checkOutputSlotForEmptyOrBucket(output.m_41777_()))) {
            Fluid fluid = ((BucketItem)input.m_41777_().m_41720_()).getFluid();
            if (inputTank.isEmpty() || inputTank.getFluid().isFluidEqual(new FluidStack(fluid, 1000)) && inputTank.getFluidAmount() + 1000 <= inputTank.getTankCapacity(0)) {
                inputTank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                handler.extractItem(slot1, 1, false);
                handler.insertItem(slot2, new ItemStack((ItemLike)Items.f_42446_, 1), false);
                return true;
            }
        }
        return false;
    }

    public boolean outputFluid(RelationalTank tank, int slot1, int slot2) {
        ItemStack inputSlot = tank.getInput();
        ItemStack outputSlot = tank.getOutput();
        FluidTank outputTank = tank.getTank();
        ItemStackHandler handler = this.getInventoryHandler();
        if (inputSlot.m_41720_() == Items.f_42446_ && outputTank.getFluidAmount() >= 1000 && inputSlot.m_41613_() > 0 && outputSlot.m_41777_() == ItemStack.f_41583_) {
            ItemStack bucketStack = new ItemStack((ItemLike)outputTank.getFluid().getRawFluid().m_6859_(), 1);
            outputTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            handler.extractItem(slot1, 1, false);
            handler.insertItem(slot2, bucketStack, false);
            return true;
        }
        return false;
    }

    public boolean outputFluidStatic(RelationalTank tank, int slot) {
        ItemStack inputSlot = tank.getOutput();
        FluidTank outputTank = tank.getTank();
        ItemStackHandler handler = this.getInventoryHandler();
        if (inputSlot.m_41777_().m_41720_() == Items.f_42446_ && inputSlot.m_41777_().m_41613_() == 1 && outputTank.getFluidAmount() >= 1000) {
            ItemStack bucketStack = new ItemStack((ItemLike)outputTank.getFluid().getRawFluid().m_6859_(), 1);
            outputTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            handler.extractItem(slot, 1, false);
            handler.insertItem(slot, bucketStack, false);
            return true;
        }
        return false;
    }

    public IFluidHandler createFluidHandler(final VEFluidRecipe veRecipe, final RelationalTank ... relationalTanks) {
        return new IFluidHandler(){

            public int getTanks() {
                return relationalTanks.length;
            }

            @Nonnull
            public FluidStack getFluidInTank(int tank) {
                for (RelationalTank t : relationalTanks) {
                    if (t.getId() != tank) continue;
                    return t.getTank() == null ? FluidStack.EMPTY : t.getTank().getFluid();
                }
                VoluminousEnergy.LOGGER.debug("Invalid tankId in VEFluidTileEntity for getFluidInTank");
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                for (RelationalTank t : relationalTanks) {
                    if (t.getId() != tank) continue;
                    return t.getTank() == null ? 0 : t.getTank().getCapacity();
                }
                VoluminousEnergy.LOGGER.debug("Invalid tankId in VEFluidTileEntity for getTankCapacity");
                return 0;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                try {
                    RelationalTank[] relationalTankArray = relationalTanks;
                    int n = relationalTankArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        RelationalTank t = relationalTankArray[n2];
                        if (t.getTankType() == TankType.INPUT) {
                            ItemStack bucketStack = new ItemStack((ItemLike)stack.getRawFluid().m_6859_());
                            VEFluidRecipe recipe = VEFluidTileEntity.this.f_58857_.m_7465_().m_44015_(veRecipe.m_6671_(), (Container)new SimpleContainer(new ItemStack[]{bucketStack}), VEFluidTileEntity.this.f_58857_).orElse(null);
                            return recipe != null && t.getTank() != null && t.getTank().isFluidValid(stack);
                        }
                        AtomicBoolean recipeHit = new AtomicBoolean(false);
                        veRecipe.getIngredientList().forEach(i -> {
                            VEFluidRecipe recipe = VEFluidTileEntity.this.f_58857_.m_7465_().m_44015_(veRecipe.m_6671_(), (Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)i)}), VEFluidTileEntity.this.f_58857_).orElse(null);
                            if (recipe != null && recipe.getFluids().get(t.getOutputID()).getFluid().m_6212_(stack.getFluid())) {
                                recipeHit.set(true);
                            }
                        });
                        return recipeHit.get() && t.getTank() != null && t.getTank().isFluidValid(stack);
                    }
                }
                catch (Exception e) {
                    VoluminousEnergy.LOGGER.debug("ERROR with isFluidValid in VEFluidTileEntity");
                }
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                for (RelationalTank t : relationalTanks) {
                    if ((!this.isFluidValid(t.getId(), resource) || !t.getTank().isEmpty()) && !resource.isFluidEqual(t.getTank().getFluid())) continue;
                    return t.getTank().fill(resource, action);
                }
                return 0;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                for (RelationalTank t : relationalTanks) {
                    if (!resource.isFluidEqual(t.getTank().getFluid())) continue;
                    return t.getTank().drain(resource, action);
                }
                return FluidStack.EMPTY;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                for (RelationalTank t : relationalTanks) {
                    if (t.getTank().getFluidAmount() <= 0) continue;
                    if (((Boolean)Config.ALLOW_EXTRACTION_FROM_INPUT_TANKS.get()).booleanValue()) {
                        return t.getTank().drain(maxDrain, action);
                    }
                    if (t.getTankType() == TankType.INPUT) continue;
                    return t.getTank().drain(maxDrain, action);
                }
                return FluidStack.EMPTY;
            }
        };
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        for (RelationalTank relationalTank : this.getRelationalTanks()) {
            CompoundTag compoundTag = tag.m_128469_(relationalTank.getTankName());
            relationalTank.getTank().readFromNBT(compoundTag);
            relationalTank.readGuiProperties(tag);
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        for (RelationalTank relationalTank : this.getRelationalTanks()) {
            CompoundTag compoundTag = new CompoundTag();
            relationalTank.getTank().writeToNBT(compoundTag);
            tag.m_128365_(relationalTank.getTankName(), (Tag)compoundTag);
            relationalTank.writeGuiProperties(tag);
        }
        super.m_183515_(tag);
    }

    public int getTankCapacity() {
        return 4000;
    }

    public void updateTankPacketFromGui(boolean status, int id) {
        for (RelationalTank tank : this.getRelationalTanks()) {
            if (id != tank.getId()) continue;
            tank.setSideStatus(status);
        }
    }

    public void updateTankPacketFromGui(int direction, int id) {
        for (RelationalTank tank : this.getRelationalTanks()) {
            if (id != tank.getId()) continue;
            tank.setSideDirection(IntToDirection.IntegerToDirection(direction));
        }
    }

    @Nonnull
    public abstract List<RelationalTank> getRelationalTanks();

    public static boolean checkOutputSlotForEmptyOrBucket(ItemStack slotStack) {
        return slotStack.m_41777_() == ItemStack.f_41583_ || slotStack.m_41777_().m_41720_() == Items.f_42446_ && slotStack.m_41777_().m_41613_() < 16;
    }
}

