/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.ToolingStationContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.items.tools.multitool.Multitool;
import com.veteam.voluminousenergy.items.tools.multitool.VEMultitools;
import com.veteam.voluminousenergy.items.tools.multitool.bits.BitItem;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorFuelRecipe;
import com.veteam.voluminousenergy.recipe.ToolingRecipe;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ToolingStationTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity {
    public VESlotManager fuelTopSlotSM = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "fuel_top_slot");
    public VESlotManager fuelBottomSlotSM = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "fuel_bottom_slot");
    public VESlotManager mainToolSlotSM = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "main_tool_slot");
    public VESlotManager bitSlotSM = new VESlotManager(3, Direction.SOUTH, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "bit_slot");
    public VESlotManager multitoolBaseSM = new VESlotManager(4, Direction.EAST, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "multitool_base_slot");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(ToolingStationTile.this.fuelTopSlotSM);
            this.add(ToolingStationTile.this.fuelBottomSlotSM);
            this.add(ToolingStationTile.this.mainToolSlotSM);
            this.add(ToolingStationTile.this.bitSlotSM);
            this.add(ToolingStationTile.this.multitoolBaseSM);
        }
    };
    RelationalTank fuelTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "fuel_tank:fuel_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(ToolingStationTile.this.fuelTank);
        }
    };
    private final ItemStackHandler inventory = this.createHandler();

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public ToolingStationTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.TOOLING_STATION_TILE.get(), pos, state);
        this.fuelTank.setValidFluids(RecipeUtil.getCombustibleFuelsWithoutLevel());
    }

    @Override
    public void tick() {
        ToolingRecipe toolingRecipe;
        this.updateClients();
        ItemStack fuelInput = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack fuelOutput = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack mainTool = this.inventory.getStackInSlot(2);
        ItemStack toolBit = this.inventory.getStackInSlot(3).m_41777_();
        ItemStack toolBase = this.inventory.getStackInSlot(4).m_41777_();
        this.fuelTank.setInput(fuelInput.m_41777_());
        this.fuelTank.setOutput(fuelOutput.m_41777_());
        if (this.inputFluid(this.fuelTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.fuelTank, 0, 1)) {
            return;
        }
        CombustionGeneratorFuelRecipe fuelRecipe = RecipeUtil.getFuelCombustionRecipe(this.f_58857_, this.fuelTank.getTank().getFluid());
        if (fuelRecipe != null && !mainTool.m_41619_()) {
            mainTool.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluid -> {
                FluidStack itemFluid = fluid.getFluidInTank(0);
                FluidStack toolingStationFluid = this.fuelTank.getTank().getFluid().copy();
                int tankCapacity = fluid.getTankCapacity(0);
                if (itemFluid.getAmount() < tankCapacity && (itemFluid.isFluidEqual(toolingStationFluid) || itemFluid.isEmpty())) {
                    int toTransfer;
                    if (!itemFluid.isEmpty()) {
                        toTransfer = Math.min(toolingStationFluid.getAmount(), itemFluid.getAmount());
                        toTransfer = Math.min(toTransfer, tankCapacity - itemFluid.getAmount());
                    } else {
                        toTransfer = Math.min(toolingStationFluid.getAmount(), tankCapacity);
                    }
                    if (toTransfer > 0) {
                        this.fuelTank.getTank().drain(toTransfer, IFluidHandler.FluidAction.EXECUTE);
                        toolingStationFluid.setAmount(toTransfer);
                        fluid.fill(toolingStationFluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                        this.inventory.getStackInSlot(4).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(baseFluid -> baseFluid.fill(toolingStationFluid, IFluidHandler.FluidAction.EXECUTE));
                    }
                }
            });
        }
        if (mainTool.m_41619_() && this.inventory.getStackInSlot(2).m_41619_()) {
            ToolingRecipe toolingRecipe2;
            if (!toolBit.m_41619_() && !toolBase.m_41619_() && (toolingRecipe2 = RecipeUtil.getToolingRecipeFromBitAndBase(this.f_58857_, toolBit.m_41777_(), toolBase.m_41777_())) != null) {
                ItemStack craftedTool = new ItemStack((ItemLike)toolingRecipe2.result.m_41720_(), 1);
                craftedTool.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidTool -> toolBase.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidBase -> {
                    FluidStack baseFluid = fluidBase.getFluidInTank(0).copy();
                    fluidTool.fill(baseFluid, IFluidHandler.FluidAction.EXECUTE);
                }));
                this.inventory.setStackInSlot(2, craftedTool);
            }
        } else if (!mainTool.m_41619_() && toolBase.m_41619_() && toolBit.m_41619_() && (toolingRecipe = RecipeUtil.getToolingRecipeFromResult(this.f_58857_, mainTool.m_41777_())) != null) {
            this.inventory.setStackInSlot(3, new ItemStack((ItemLike)toolingRecipe.getBits().get(0)));
            ItemStack baseStack = new ItemStack((ItemLike)toolingRecipe.getBases().get(0));
            baseStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(baseFluid -> mainTool.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(toolFluid -> {
                FluidStack fluidTool = toolFluid.getFluidInTank(0).copy();
                baseFluid.fill(fluidTool, IFluidHandler.FluidAction.EXECUTE);
            }));
            this.inventory.setStackInSlot(4, baseStack);
            this.inventory.setStackInSlot(2, mainTool.m_41777_());
        }
    }

    private IFluidHandler createFuelFluidHandler() {
        return this.createFluidHandler(new CombustionGeneratorFuelRecipe(), this.fuelTank);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                if (slot == 2 && this.getStackInSlot(2).m_41619_()) {
                    if (!this.getStackInSlot(3).m_41619_() && !this.getStackInSlot(4).m_41619_()) {
                        this.setStackInSlot(3, ItemStack.f_41583_);
                        this.setStackInSlot(4, ItemStack.f_41583_);
                    }
                } else if (!(slot != 3 && slot != 4 || this.getStackInSlot(2).m_41619_() || !this.getStackInSlot(3).m_41619_() && !this.getStackInSlot(4).m_41619_())) {
                    this.setStackInSlot(2, ItemStack.f_41583_);
                }
                ToolingStationTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 2) {
                    return stack.m_41720_() instanceof BucketItem;
                }
                if (slot == 2) {
                    return stack.m_41720_() instanceof Multitool && stack.m_41720_() != VEMultitools.EMPTY_MULTITOOL.get();
                }
                if (slot == 3) {
                    return stack.m_41720_() instanceof BitItem;
                }
                if (slot == 4) {
                    return stack.m_41720_() == VEMultitools.EMPTY_MULTITOOL.get();
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!(slot != 2 || this.getStackInSlot(3).m_41619_() && this.getStackInSlot(4).m_41619_())) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new ToolingStationContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public boolean hasValidRecipe() {
        return this.inventory.getStackInSlot(2) != ItemStack.f_41583_ && this.inventory.getStackInSlot(3) != ItemStack.f_41583_ && this.inventory.getStackInSlot(4) != ItemStack.f_41583_;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.fuelTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    public RelationalTank getInputTank() {
        return this.fuelTank;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.TOOLING_STATION_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return 0;
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.TOOLING_STATION_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 0;
    }
}

