/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.StirlingGeneratorContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPowerGenerator;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.recipe.StirlingGeneratorRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.SlotType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class StirlingGeneratorTile
extends VoluminousTileEntity
implements IVEPowerGenerator,
IVECountable {
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> this.inventory);
    public VESlotManager slotManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "slot_manager");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(StirlingGeneratorTile.this.slotManager);
        }
    };
    private int energyRate;
    private final ItemStackHandler inventory = this.createHandler();

    public StirlingGeneratorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.STIRLING_GENERATOR_TILE.get(), pos, state);
    }

    @Deprecated
    public StirlingGeneratorTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.STIRLING_GENERATOR_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        this.handler.ifPresent(h -> {
            ItemStack input = h.getStackInSlot(0).m_41777_();
            StirlingGeneratorRecipe recipe = RecipeUtil.getStirlingGeneratorRecipe(this.f_58857_, input.m_41777_());
            if (this.counter > 0) {
                if (this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) + this.energyRate <= (Integer)Config.STIRLING_GENERATOR_MAX_POWER.get()) {
                    --this.counter;
                    this.energy.ifPresent(e -> e.addEnergy(this.energyRate));
                }
                if (++this.sound_tick == 19) {
                    this.sound_tick = 0;
                    if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                this.m_6596_();
            } else if (!input.m_41619_() && recipe != null && recipe.getEnergyPerTick() * recipe.getProcessTime() + this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) <= (Integer)Config.STIRLING_GENERATOR_MAX_POWER.get()) {
                h.extractItem(0, recipe.ingredientCount, false);
                this.counter = recipe.getProcessTime();
                this.energyRate = recipe.getEnergyPerTick();
                this.length = this.counter;
                this.m_6596_();
            }
            if (this.counter == 0) {
                this.energyRate = 0;
            }
            this.sendOutPower();
        });
    }

    public static int recieveEnergy(BlockEntity tileEntity, Direction from, int maxReceive) {
        return tileEntity.getCapability(ForgeCapabilities.ENERGY, from).map(handler -> handler.receiveEnergy(maxReceive, false)).orElse(0);
    }

    private void sendOutPower() {
        this.energy.ifPresent(energy -> {
            for (Direction dir : Direction.values()) {
                BlockEntity tileEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                Direction opposite = dir.m_122424_();
                if (tileEntity == null) continue;
                int smallest = Math.min((Integer)Config.STIRLING_GENERATOR_SEND.get(), energy.getEnergyStored());
                int received = StirlingGeneratorTile.recieveEnergy(tileEntity, opposite, smallest);
                energy.consumeEnergy(received);
                if (energy.getEnergyStored() <= 0) break;
            }
        });
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energyRate = tag.m_128451_("energy_rate");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("energy_rate", this.energyRate);
        super.m_183515_(tag);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                StirlingGeneratorTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ItemStack referenceStack = stack.m_41777_();
                referenceStack.m_41764_(64);
                StirlingGeneratorRecipe recipe = RecipeUtil.getStirlingGeneratorRecipe(StirlingGeneratorTile.this.f_58857_, stack);
                return slot == 0 && recipe != null && recipe.getIngredient().test(referenceStack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                StirlingGeneratorRecipe recipe = RecipeUtil.getStirlingGeneratorRecipe(StirlingGeneratorTile.this.f_58857_, stack);
                if (slot == 0 && recipe != null) {
                    for (ItemStack testStack : recipe.getIngredient().m_43908_()) {
                        if (stack.m_41720_() != testStack.m_41720_()) continue;
                        return super.insertItem(slot, stack, simulate);
                    }
                }
                return stack;
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new StirlingGeneratorContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nullable
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public int progressCounterPX(int px) {
        if (this.counter == 0) {
            return 0;
        }
        return px * (this.counter * 100 / this.length) / 100;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public int getEnergyRate() {
        return this.energyRate;
    }

    @Override
    public void updatePacketFromGui(boolean status, int slotId) {
        if (slotId == this.slotManager.getSlotNum()) {
            this.slotManager.setStatus(status);
        }
    }

    @Override
    public void updatePacketFromGui(int direction, int slotId) {
        if (slotId == this.slotManager.getSlotNum()) {
            this.slotManager.setDirection(direction);
        }
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.STIRLING_GENERATOR_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return 0;
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.STIRLING_GENERATOR_SEND.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 0;
    }
}

